require([
    "jira/projects/components/app",
    "jquery",
    'internal/browser-metrics',
    "jira/skate",
    "jira/dialog/form-dialog",
    "jira/projects/abstract-model/submit-model-states",
    "jira/projects/components/component-form-view",
    "jira/projects/components/submitmodel",
    "jira/projects/components/analytics"
], function (
    App,
    $,
    metrics,
    skate,
    FormDialog,
    SubmitModelStates,
    ComponentFormView,
    SubmitModel,
    Analytics
) {
    "use strict";

    App.on("navigate", function () {
        this.trigger("navigateEvent");
    });

    Analytics.listenForCommonEvents(App);

    metrics.start({
        key: 'jira.project.components',
        ready: [
            '#components-table'
        ]
    });

    // tracking potential performance problem, component page app is not disabled even though the surrounding page is loaded
    markPerformance('jira.projects.components.init');

    skate("components-page-app", {
        type: skate.type.CLASSNAME,
        attached: function (element) {
            markPerformance('jira.projects.components.start');
            App.start({
                container: $(element)
            });
        }
    });

    var dialog = new FormDialog({
        defineResources: function () {
            this.requireResource("com.atlassian.jira.jira-projects-plugin:component-edit-init")
        },

        trigger: ".component-edit-dialog",

        onDialogFinished: function () {
            var componentId = this.$popupContent.find('[type=hidden][name=componentId]').val();

            var submitModel = new SubmitModel({id: componentId, project: App.submitController.getOption("project")});
            submitModel.detailsSync()
                .done(function () {
                    var model = App.pageableItems.updateElement(submitModel);
                    model.set("state", SubmitModelStates.SUCCESSFUL);
                    setTimeout(function () {
                        model.set("state", SubmitModelStates.READY);
                    }, 5000);
                });

            this.hide();
        }
    });

    function markPerformance(key) {
        window.performance && window.performance.mark && window.performance.mark('jira.projects.components.' + key);
    }
});
