AJS.test.require([
    'com.atlassian.jira.jira-projects-plugin:components-page-assets'
], function() {
    "use strict";

    var $ = require("jquery");
    var SubmitView = require("jira/projects/components/submitview");
    var SubmitModel = require("jira/projects/components/submitmodel");
    var Collection = require("jira/projects/components/pageablecomponentscollection");
    var FilterModel = require("jira/projects/components/filter-model");

    var USED_NAME = "something";
    var UNIQUE_NAME = "foo";

    var FAKE_PICKER = {"users":[{"name":"admin","html":"<div class=\"yad\"><b>Admin</b>istrator&nbsp;-&nbsp;<b>admin</b>@example.com&nbsp;(<b>admin</b>)</div>","displayName":"Administrator","avatarUrl":"http://localhost:2990/jira/secure/useravatar?size=xsmall&avatarId=10062"}],"total":1,"footer":"jira.ajax.autocomplete.user.more.results"};
    var FAKE_PICKER_EMPTY = {"users":[],"total":0,"footer":"jira.ajax.autocomplete.user.more.results"};

    module('SubmitView', {
        setup: function () {
            this.sandbox = sinon.sandbox.create({ useFakeServer: true });

            var data = [{
                name: USED_NAME
            }];
            this.pageableItems = new Collection(null, {
                data: data
            });
            this.filterModel = new FilterModel({
                pageableCollection: this.pageableItems
            });

            this.submitView = new SubmitView({
                pageableItems: this.pageableItems,
                model: new SubmitModel()
            });

            this.submitView.render();

            $('#qunit-fixture').append(this.submitView.$el);

            this.$componentName = this.submitView.$el.find('.components-add__name');
            this.$lead = this.submitView.$el.find('.components-add__lead');
            this.$assignee = this.submitView.$el.find('.components-add__assignee');
            this.$confirm = this.submitView.$el.find('.components-add__confirm');

            // SingleSelect will assign to input field events after 15ms
            stop();
            setTimeout(start, 30);
        },
        teardown: function () {
        }
    });

    test('Should validate unique name on input', function () {
        this.$componentName.find('input').val(USED_NAME).trigger("input");
        equal(this.$componentName.find('.error').html(), "project.page.components.add.error.already.exists", "Error exists is visible");

        this.$componentName.find('input').val(UNIQUE_NAME).trigger("input");
        equal(this.$componentName.find('.error-container').html(), "", "Error is gone");
    });

    test('Should validate unique name on input regardless of case', function () {
        this.$componentName.find('input').val(USED_NAME.toUpperCase()).trigger("input");
        equal(this.$componentName.find('.error').html(), "project.page.components.add.error.already.exists", "Error exists is visible");

        this.$componentName.find('input').val(UNIQUE_NAME).trigger("input");
        equal(this.$componentName.find('.error-container').html(), "", "Error is gone");
    });

    test('Should validate unique name when list is filtered', function () {
        this.filterModel.set("contains", UNIQUE_NAME);
        this.filterModel.filterCollection();

        this.$componentName.find('input').val(USED_NAME).trigger("input");

        equal(this.$componentName.find('.error').html(), "project.page.components.add.error.already.exists", "Error exists is visible");
    });

    test('Should disable button after render', function () {
        equal(this.submitView.$el.find('.components-add__confirm button').attr("disabled"), "disabled", "Button is disabled");
    });

    test('Should enable button after component name and assignee are selected', function () {
        this.$componentName.find('input').val(UNIQUE_NAME).trigger("input");
        this.$assignee.find('input').val("project.page.components.add.assignee.component.lead")
            .trigger("keyup").trigger("blur");

        equal(this.submitView.$el.find('.components-add__confirm button').attr("disabled"), undefined, "Button is enabled");
    });

    test('Should disable button after component was added', function () {
        this.$componentName.find('input').val(UNIQUE_NAME).trigger("input");
        this.$assignee.find('input').val("project.page.components.add.assignee.component.lead")
            .trigger("keyup").trigger("blur");

        var $button = this.submitView.$el.find('.components-add__confirm button');
        equal($button.attr("disabled"), undefined, "Button is enabled");

        $button.click();
        equal($button.attr("disabled"), "disabled", "Button is disabled");
    });

    test('Should ignore invalid assignee type', function () {
        var $input = this.$assignee.find('input');

        $input.val("something").trigger("keyup").trigger("blur");
        equal($input.val(), "project.page.components.add.assignee.component.lead", "Field was reset");

        $input.val("project.page.components.add.assignee.project.default").trigger("keyup").trigger("blur");
        equal($input.val(), "project.page.components.add.assignee.project.default", "Field was not reset");

        $input.val("wrong").trigger("keyup").trigger("blur");
        equal($input.val(), "project.page.components.add.assignee.component.lead", "Field was reset");
    });

    test('Should persist valid user name on tab', function () {
        var $input = this.$lead.find('input');

        $input.val("admin").trigger("input");
        this.sandbox.server.requests[0].respond(200, { "Content-Type": "application/json" }, JSON.stringify(FAKE_PICKER));
        $input.trigger({ type: "keydown",  which: 9 }).trigger("blur");

        notEqual($input.val().indexOf("Administrator"), -1, "Field was not reset");
    });

    test('Should allow lead reset', function () {
        var $input = this.$lead.find('input');

        $input.val("admin").trigger("input");
        this.sandbox.server.requests[0].respond(200, { "Content-Type": "application/json" }, JSON.stringify(FAKE_PICKER));
        $input.trigger({ type: "keydown",  which: 9 }).trigger("blur");

        notEqual($input.val().indexOf("Administrator"), -1, "Field was not reset");

        $input.val("").trigger("input").trigger({ type: "keydown",  which: 9 }).trigger("blur");

        equal($input.val(), "", "Field was reset");
    });

    test('Should not persist invalid user name on tab', function () {
        var $input = this.$lead.find('input');

        $input.val("user").trigger("input");
        this.sandbox.server.requests[0].respond(200, { "Content-Type": "application/json" }, JSON.stringify(FAKE_PICKER_EMPTY));
        $input.trigger({ type: "keydown",  which: 9 }).trigger("blur");

        equal($input.val(), "", "Field was reset");
    });

    test('Should not persist valid user name on blur', function () {
        var $input = this.$lead.find('input');

        $input.val("admin").trigger("input");
        this.sandbox.server.requests[0].respond(200, { "Content-Type": "application/json" }, JSON.stringify(FAKE_PICKER));
        $input.trigger("blur");

        equal($input.val(), "", "Field was reset");
    });
});