define("jira/projects/components/component-form-view", [
    "jira/util/formatter",
    "underscore",
    "jira/projects/libs/marionette",
    "jira/ajs/select/single-select"
], function(formatter, _, Marionette, SingleSelect) {
    "use strict";

    return Marionette.ItemView.extend({
        ui: {},

        events: {},

        componentFormUI: {
            "assigneeTypeInput": "input#assigneeType-field",
            "assigneeTypeSelect": "select[name=assigneeType]"
        },

        componentFormEvents: {
            "keyup @ui.componentLeadInput": "onComponentLeadKeyup",
            "change @ui.componentLeadSelect": "onComponentLeadChange"
        },

        constructor: function (options) {
            _.extend(this.ui, this.componentFormUI, options ? options.ui : {});
            _.extend(this.events, this.componentFormEvents, options ? options.events : {});

            Marionette.ItemView.prototype.constructor.apply(this, arguments);
        },

        wrapAndRebindElements: function () {
            this.assigneeTypeSingleSelect = new SingleSelect({element: this.$(this.ui.assigneeTypeSelect)});
            this.bindUIElements();
        },

        getUserFullName: function () {
            return this.ui.componentLeadSelect.find("option[selected]").text();
        },

        onComponentLeadKeyup: function (event) {
            if (event && event.type == "keyup" && event.target.value != "") {
                return false;
            }
            return this.onComponentLeadChange(event);
        },

        onComponentLeadChange: function (event, model) {
            var componentLeadName = (model && model.value())
                ? this.getUserFullName()
                : formatter.I18n.getText("project.page.components.add.assignee.unassigned");
            var componentLeadText = formatter.I18n.getText("project.page.components.add.assignee.component.lead", componentLeadName);

            var descriptor = this.assigneeTypeSingleSelect.model.getDescriptor("COMPONENT_LEAD");

            descriptor.properties.label = componentLeadText;
            if (descriptor.selected()) {
                this.ui.assigneeTypeInput.val(componentLeadText);
            }
        }
    });
});