AJS.test.require(["com.atlassian.jira.jira-projects-plugin:abstract-list-page"], function(){
    "use strict";

    var jQuery = require("jquery");

    var NavigationUtils = require("jira/projects/abstract-list/navigation-utils");
    var ALPaginationView = require("jira/projects/abstract-list/pagination-view");

    module('jira/projects/abstract-list/pagination-view', {
        setup: function () {
            sinon.stub(NavigationUtils, "getQueryStringParam")
                    .returns("");
            sinon.stub(NavigationUtils, "navigate");

            var $markup = jQuery(
                    '<ol class="aui-nav aui-nav-pagination">' +
                    '    <li class="aui-nav-previous"><a href="" data-page="1">Prev</a></li>' +
                    '</ol>'
            );
            this.view = new ALPaginationView({
                el: $markup,
                collection: {
                    getPage: sinon.stub(),
                    on: sinon.stub(),
                    off: sinon.stub(),
                    state: {
                        firstPage: 1,
                        lastPage: 20,
                        currentPage: 1
                    },
                    Events: []
                },
                model: {
                    getFilterQueryStringParams: sinon.stub().returns(""),
                    on: sinon.stub(),
                    off: sinon.stub()
                }
            });
            this.view.bindUIElements();
        },
        teardown: function () {
            NavigationUtils.getQueryStringParam.restore();
            NavigationUtils.navigate.restore();
        }
    });

    test('Should change url and displayed items on page click.', function () {
        jQuery(this.view.ui.page[0]).click();
        sinon.assert.calledOnce(this.view.model.getFilterQueryStringParams);
        sinon.assert.calledWith(NavigationUtils.navigate, "&page=1");
        sinon.assert.calledWith(this.view.collection.getPage, 1);
    });

    test('First page should be calculated correctly', function () {
        this.view.collection.state.currentPage = 1;
        var result = this.view.serializeData();
        equal(result.firstPage, 1);

        this.view.collection.state.currentPage = 6;
        result = this.view.serializeData();
        equal(result.firstPage, 1);

        this.view.collection.state.currentPage = 7;
        result = this.view.serializeData();
        equal(result.firstPage, 2);

        this.view.collection.state.currentPage = 10;
        result = this.view.serializeData();
        equal(result.firstPage, 5);
    });


    test('Last page should be calculated correctly', function () {
        this.view.collection.state.currentPage = 20;
        var result = this.view.serializeData();
        equal(result.lastPage, 20);

        this.view.collection.state.currentPage = 15;
        result = this.view.serializeData();
        equal(result.lastPage, 20);

        this.view.collection.state.currentPage = 14;
        result = this.view.serializeData();
        equal(result.lastPage, 19);

        this.view.collection.state.currentPage = 10;
        result = this.view.serializeData();
        equal(result.lastPage, 15);
    });
});

