define("jira/projects/abstract-list/navigation-utils", [
    "atlassian/libs/uri-1.14.1",
    "jira-projects-backbone",
    "exports"
], function(URI, Backbone, exports) {
    "use strict";

    exports.pushStateSupported = !!history.pushState;
    exports.getBackboneHistoryRoot = function getRoot() {
        return (exports.pushStateSupported)
                ? ""
                : exports.getRoot();
    };
    exports.getRoot = function getRoot() {
        var selectedItem = exports.getQueryStringParam("selectedItem");
        return document.location.pathname + (selectedItem ? ("?selectedItem=" + selectedItem) : '?');
    };
    exports.navigate = function navigate(location) {
        if (exports.pushStateSupported) {
            location = exports.getRoot() + location;
        }
        Backbone.history.navigate(location);
    };
    exports.append = function append(name, value) {
        var uri = new URI(location.href);
        uri = uri.addSearch(name, value);

        history.replaceState(null, "", uri.href());
    };
    /**
     * Get query sting param's value from the url. Optionally hash can be included in the search.
     *
     * @param name {string} The name of the parameter we're retrieving the value for.
     * @param includeHash {boolean} Whether to search for the parameter also in the hash fragment.
     * @param [location] a <tt>window.location</tt> object to check the URL from. leave blank to use the actual window implementation.
     *
     * @returns {string|undefined} The value of the parameter (preferring the one in the hash fragment if we're searching there, too).
     * or <tt>undefined</tt> if the parameter is not present.
     */
    exports.getQueryStringParam = function getQueryStringParam(name, includeHash, location) {
        location = location || window.location;
        if (!name) {
            return;
        }
        var params = location.search.substr(1).split('&');
        if (includeHash) {
            params = params.concat(location.hash.substr(1).split('&'));
        }
        for (var i = params.length - 1; i >= 0; i--) {
            var param = params[i].split('=');
            if (param.length !== 2) {
                continue;
            }
            if (name === param[0]) {
                return decodeURIComponent(param[1].replace(/\+/g, " "));
            }
        }
    }
});

AJS.namespace("JIRA.Projects.AbstractList.NavigationUtils", null, require("jira/projects/abstract-list/navigation-utils"));
