/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.web;

import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.page.release.ReleasePageContextProvider;
import com.atlassian.jira.projects.page.release.VersionToVersionViewTransformer;
import com.atlassian.jira.projects.page.release.VersionView;
import com.atlassian.jira.projects.util.ProjectPermissions;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionEditAction
extends JiraWebActionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(VersionEditAction.class);
    private final I18nHelper i18nHelper;
    private final ProjectService projectService;
    private final ProjectPermissions projectPermissions;
    private final VersionService versionService;
    private final ReleasePageContextProvider contextProvider;
    private final VersionToVersionViewTransformer versionToVersionView;
    private Long versionId;
    private String name;
    private String description;
    private String startDate;
    private String releaseDate;
    private String decorator;
    private Version version;
    private VersionView versionView;
    private Project project;
    private final ImmutableMap.Builder builder;

    public VersionEditAction(I18nHelper i18nHelper, ProjectService projectService, ProjectPermissions projectPermissions, ReleasePageContextProvider contextProvider, VersionToVersionViewTransformer versionToVersionView) {
        this.i18nHelper = i18nHelper;
        this.projectService = projectService;
        this.versionService = (VersionService)ComponentAccessor.getComponent(VersionService.class);
        this.projectPermissions = projectPermissions;
        this.contextProvider = contextProvider;
        this.versionToVersionView = versionToVersionView;
        this.builder = ImmutableMap.builder();
    }

    public String doDefault() throws Exception {
        if (!this.fillObjectsFromVersionId() || !this.checkPermissions()) {
            return "error";
        }
        this.contextProvider.includeCalendarParameters();
        this.fillVersionParameters();
        return super.doDefault();
    }

    private boolean fillObjectsFromVersionId() {
        Either<ErrorCollection, Project> projectEither;
        VersionService.VersionResult versionById = this.versionService.getVersionById(this.getLoggedInUser(), this.getVersionId());
        this.addErrorCollection(versionById.getErrorCollection());
        if (this.hasAnyErrors()) {
            LOG.debug("Was unable to get version.");
            return false;
        }
        this.version = versionById.getVersion();
        if (this.version != null) {
            this.versionView = this.versionToVersionView.getView(this.version);
        }
        if ((projectEither = this.projectService.getProject(this.version.getProjectId())).isLeft()) {
            this.addErrorCollection((ErrorCollection)projectEither.left().get());
            LOG.debug("Was unable to get project.");
            return false;
        }
        this.project = (Project)projectEither.right().get();
        return true;
    }

    private boolean checkPermissions() {
        if (!this.projectPermissions.hasProjectAdminPermission(this.getLoggedInUser(), this.project).booleanValue()) {
            this.addErrorMessage(this.i18nHelper.getText("project.page.release.edit.no.permission"), ErrorCollection.Reason.FORBIDDEN);
            this.builder.put((Object)"forbidden", (Object)true);
            LOG.debug("User does not have permission to admin project.");
            return false;
        }
        return true;
    }

    private void fillVersionParameters() {
        this.setName(this.version.getName());
        this.setDescription(this.version.getDescription());
        this.setStartDate(Optional.ofNullable(this.versionView).map(view -> view.getStartDate().getFormatted()).orElse(""));
        this.setReleaseDate(Optional.ofNullable(this.versionView).map(view -> view.getReleaseDate().getFormatted()).orElse(""));
    }

    protected String doExecute() throws Exception {
        this.builder.put((Object)"globalSuccess", (Object)this.getI18nHelper().getText("project.page.release.edit.save.success"));
        if (this.isInlineDialogMode()) {
            return this.returnComplete(this.getVersionsUrl());
        }
        return "success";
    }

    @ActionViewDataMappings(value={"success", "input", "error"})
    public Map<String, Object> getContextParams() {
        if (this.versionView != null) {
            this.builder.put((Object)"version", (Object)this.versionView);
        }
        this.builder.put((Object)"errors", (Object)this);
        if (this.getHasErrorMessages()) {
            this.builder.put((Object)"globalErrors", (Object)this.getErrorMessages());
        }
        if (this.project != null) {
            this.builder.put((Object)"urlReturn", (Object)this.getVersionsUrl());
            this.builder.put((Object)"urlCancel", (Object)this.getVersionsUrl());
            this.builder.put((Object)"projectKey", (Object)this.project.getKey());
        }
        if (this.getDecorator() != null) {
            this.builder.put((Object)"decorator", (Object)this.getDecorator());
        }
        return this.builder.build();
    }

    private String getVersionsUrl() {
        return String.format("%s/projects/%s?selectedItem=com.atlassian.jira.jira-projects-plugin:release-page", JiraUrl.constructBaseUrl((HttpServletRequest)this.request), this.project.getKey());
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public String getDecorator() {
        return this.decorator;
    }

    public void setDecorator(String decorator) {
        this.decorator = decorator;
    }
}

