/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.tabpanel;

import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.tabpanel.TabPanelHeaderRenderer;
import com.atlassian.jira.projects.tabpanel.TabPanelService;
import com.atlassian.jira.projects.util.BrowseContextFactory;
import com.atlassian.ozymandias.PluginPointVisitor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.web.renderer.RendererException;
import com.atlassian.plugin.web.renderer.WebPanelRenderer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TabPanelWebPanelRenderer
implements WebPanelRenderer {
    private final BrowseContextFactory browseContextFactory;
    private final TabPanelHeaderRenderer tabPanelHeaderRenderer;
    private final TabPanelService tabPanelService;

    @Autowired
    public TabPanelWebPanelRenderer(BrowseContextFactory browseContextFactory, TabPanelHeaderRenderer tabPanelHeaderRenderer, TabPanelService tabPanelService) {
        this.browseContextFactory = browseContextFactory;
        this.tabPanelHeaderRenderer = tabPanelHeaderRenderer;
        this.tabPanelService = tabPanelService;
    }

    public String getResourceType() {
        return "tabPanel";
    }

    public void render(String templateName, Plugin plugin, Map<String, Object> context, final Writer writer) throws IOException, RendererException {
        final String projectKey = String.valueOf(context.get("projectKey"));
        final String tabPanelKey = String.valueOf(context.get("tabPanelKey"));
        SafePluginPointAccess.to().descriptors(this.tabPanelService.getVisibleTabPanelDescriptorsForProject(projectKey), (PluginPointVisitor)new PluginPointVisitor<ProjectTabPanelModuleDescriptor, ProjectTabPanel>(){

            public void visit(ProjectTabPanelModuleDescriptor descriptor, ProjectTabPanel panel) {
                if (StringUtils.equals((CharSequence)tabPanelKey, (CharSequence)descriptor.getCompleteKey())) {
                    TabPanelWebPanelRenderer.this.renderPanel(writer, descriptor, panel, projectKey);
                }
            }
        });
    }

    private void renderPanel(Writer writer, ProjectTabPanelModuleDescriptor descriptor, ProjectTabPanel panel, String projectKey) {
        BrowseContext browseContext = this.browseContextFactory.create(projectKey);
        try {
            writer.append(this.tabPanelHeaderRenderer.renderHeader(descriptor));
            writer.append(panel.getHtml(browseContext));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String renderFragment(String fragment, Plugin plugin, Map<String, Object> context) throws RendererException {
        StringWriter writer = new StringWriter();
        try {
            this.render(fragment, plugin, context, writer);
        }
        catch (IOException e) {
            throw new RendererException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        return ((Object)writer).toString();
    }

    public void renderFragment(Writer writer, String fragment, Plugin plugin, Map<String, Object> context) throws RendererException, IOException {
        this.render(fragment, plugin, context, writer);
    }
}

