/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.tabpanel;

import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.projects.URLEncoder;
import com.atlassian.jira.projects.tabpanel.TabPanelService;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.ozymandias.PluginPointVisitor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TabPanelWebItemProvider
implements WebItemProvider {
    private static final Set<String> OBSOLETE_PANELS = Sets.newHashSet((Object[])new String[]{"com.atlassian.jira.jira-projects-plugin:issues-panel", "com.atlassian.jira.jira-projects-plugin:summary-panel", "com.atlassian.jira.jira-projects-plugin:components-panel", "com.atlassian.jira.jira-projects-plugin:versions-panel", "com.atlassian.jira.jira-projects-plugin:reports-panel", "com.pyxis.greenhopper.jira:greenhopper-project-panel-tab", "com.atlassian.jira.plugin.ext.bamboo:bamboo-project-tabpanel", "com.atlassian.jirafisheyeplugin:fisheye-projectpanel", "com.atlassian.jirafisheyeplugin:crucible-projectpanel", "com.atlassian.jira.ext.calendar:issuecalendar-panel"});
    private final TabPanelService tabPanelService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public TabPanelWebItemProvider(TabPanelService tabPanelService, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.tabPanelService = tabPanelService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        String projectKey = String.valueOf(context.get("projectKey"));
        ItemizeAvailable itemizeAvailable = new ItemizeAvailable(projectKey);
        SafePluginPointAccess.to().descriptors(this.tabPanelService.getVisibleTabPanelDescriptorsForProject(projectKey), (PluginPointVisitor)itemizeAvailable);
        return itemizeAvailable.result();
    }

    private Iterable<ProjectTabPanelModuleDescriptor> getTabPanels(String projectKey) {
        return this.tabPanelService.getVisibleTabPanelDescriptorsForProject(projectKey);
    }

    private String getTabPanelUrl(String projectKey, ProjectTabPanelModuleDescriptor descriptor) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        return baseUrl + "/projects/" + URLEncoder.encodePathSegment(projectKey) + "?selectedItem=" + descriptor.getCompleteKey();
    }

    private class ItemizeAvailable
    implements PluginPointVisitor<ProjectTabPanelModuleDescriptor, ProjectTabPanel> {
        final List<WebItem> webItems = Lists.newArrayList();
        final String projectKey;

        private ItemizeAvailable(String projectKey) {
            this.projectKey = projectKey;
        }

        public void visit(ProjectTabPanelModuleDescriptor descriptor, ProjectTabPanel tabPanel) {
            if (OBSOLETE_PANELS.contains(descriptor.getCompleteKey())) {
                return;
            }
            this.webItems.add(new WebFragmentBuilder(descriptor.getCompleteKey(), descriptor.getOrder()).label(descriptor.getLabel()).webItem("").url(TabPanelWebItemProvider.this.getTabPanelUrl(this.projectKey, descriptor)).build());
        }

        public List<WebItem> result() {
            return this.webItems;
        }
    }
}

