/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.subnavigator;

import com.atlassian.jira.projects.api.subnavigator.SubNavigatorSettingService;
import com.atlassian.jira.projects.subnavigator.SubNavigatorSettingResponse;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import io.atlassian.fugue.Option;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/subnav/{subNavId}")
@AnonymousAllowed
public class SubNavigatorSettingResource {
    private final SubNavigatorSettingService subNavigatorSettingService;

    public SubNavigatorSettingResource(SubNavigatorSettingService subNavigatorSettingService) {
        this.subNavigatorSettingService = subNavigatorSettingService;
    }

    @GET
    public Response getSubNavigatorPinStatus(@PathParam(value="subNavId") String subNavId) {
        Option pinnedOption = this.subNavigatorSettingService.isSubNavigationPinned(subNavId);
        SubNavigatorSettingResponse response = new SubNavigatorSettingResponse(subNavId, (Boolean)pinnedOption.getOrNull());
        return Response.ok((Object)response).build();
    }

    @PUT
    @Path(value="/pin")
    public Response pinSubNavigator(@PathParam(value="subNavId") String subNavId) {
        this.subNavigatorSettingService.pinSubNavigator(subNavId);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/unpin")
    public Response unpinSubNavigator(@PathParam(value="subNavId") String subNavId) {
        this.subNavigatorSettingService.unpinSubNavigator(subNavId);
        return Response.noContent().build();
    }

    @DELETE
    public Response deleteSubNavigatorPinStatus(@PathParam(value="subNavId") String subNavId) {
        this.subNavigatorSettingService.deleteSubNavigatorPinStatus(subNavId);
        return Response.noContent().build();
    }
}

