/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.header;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.sidebar.header.ScopeFilter;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationSection;
import com.atlassian.jira.projects.sidebar.header.ProjectHeaderRendererImpl;
import com.atlassian.jira.projects.sidebar.header.ScopeFilterJsonableMarshaller;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Path(value="/project/{projectKey}/rapidviews")
public class ScopeFilterDataResource {
    protected JiraAuthenticationContext jiraAuthenticationContext;
    protected ProjectService projectService;
    private ProjectHeaderRendererImpl projectHeaderRenderer;
    private static final String SCOPE_FILTER_LIST_LOCATION_KEY = "jira.project.sidebar.header.scope.filter.list";
    private static final String SCOPE_FILTER_LIST_SECTION_KEY = "project-sidebar-header-scope-filter-list";

    public ScopeFilterDataResource(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, ProjectHeaderRendererImpl projectHeaderRenderer, ProjectService projectService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectHeaderRenderer = projectHeaderRenderer;
        this.projectService = projectService;
    }

    @GET
    public Response getBoardsByProject(@PathParam(value="projectKey") String projectKey) throws IOException {
        Project project = this.projectService.getProjectByKey(this.jiraAuthenticationContext.getLoggedInUser(), projectKey).getProject();
        if (project == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Option<List<NavigationSection>> sectionsForScopeFilter = this.projectHeaderRenderer.getSectionsForScopeFilter(SCOPE_FILTER_LIST_LOCATION_KEY, project);
        List<NavigationItem> scopeFilterItems = this.projectHeaderRenderer.getItemsForSection(sectionsForScopeFilter, SCOPE_FILTER_LIST_SECTION_KEY);
        ScopeFilter scopeFilter = this.projectHeaderRenderer.buildScopeFilter(scopeFilterItems, null, Collections.emptyList());
        String responseData = this.prepareResponseData(scopeFilter);
        return Response.ok((Object)responseData).build();
    }

    private String prepareResponseData(ScopeFilter scopeFilter) throws IOException {
        ScopeFilterJsonableMarshaller scopeFilterJsonableMarshaller = new ScopeFilterJsonableMarshaller();
        Jsonable jsonable = scopeFilterJsonableMarshaller.marshal(scopeFilter);
        StringWriter stringWriter = new StringWriter();
        jsonable.write((Writer)stringWriter);
        return stringWriter.toString();
    }
}

