/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.header;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.sidebar.header.ScopeFilter;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationSection;
import com.atlassian.jira.projects.sidebar.header.ProjectHeaderRendererImpl;
import com.atlassian.jira.projects.sidebar.header.ScopeFilterJsonableMarshaller;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ScopeFilterDataProvider
implements WebResourceDataProvider {
    @Autowired
    protected JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    protected UserProjectHistoryManager userProjectHistoryManager;
    private ProjectHeaderRendererImpl projectHeaderRenderer;
    public static final String SCOPE_FILTER_LIST_LOCATION_KEY = "jira.project.sidebar.header.scope.filter.list";
    private static final String SCOPE_FILTER_LIST_SECTION_KEY = "project-sidebar-header-scope-filter-list";

    public ScopeFilterDataProvider(@ComponentImport ProjectHeaderRendererImpl projectHeaderRenderer, @ComponentImport UserProjectHistoryManager userProjectHistoryManager) {
        this.projectHeaderRenderer = projectHeaderRenderer;
        this.userProjectHistoryManager = userProjectHistoryManager;
    }

    public Jsonable get() {
        Project project = this.userProjectHistoryManager.getCurrentProject(10, this.jiraAuthenticationContext.getLoggedInUser());
        Option<List<NavigationSection>> sectionsForScopeFilter = this.projectHeaderRenderer.getSectionsForScopeFilter(SCOPE_FILTER_LIST_LOCATION_KEY, project);
        List<NavigationItem> scopeFilterItems = this.projectHeaderRenderer.getItemsForSection(sectionsForScopeFilter, SCOPE_FILTER_LIST_SECTION_KEY);
        ScopeFilter scopeFilter = this.projectHeaderRenderer.buildScopeFilter(scopeFilterItems, null, Collections.emptyList());
        ScopeFilterJsonableMarshaller scopeFilterJsonableMarshaller = new ScopeFilterJsonableMarshaller();
        return scopeFilterJsonableMarshaller.marshal(scopeFilter);
    }
}

