/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.onboarding.OnboardingService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.projects.api.sidebar.ProjectSidebarRenderer;
import com.atlassian.jira.projects.api.sidebar.SidebarRenderer;
import com.atlassian.jira.projects.api.sidebar.content.ProjectContentRendererRegistry;
import com.atlassian.jira.projects.api.sidebar.footer.SettingsButton;
import com.atlassian.jira.projects.api.sidebar.header.ProjectHeaderRenderer;
import com.atlassian.jira.projects.service.CurrentProjectService;
import com.atlassian.jira.projects.service.OnboardingServiceAccessor;
import com.atlassian.jira.projects.sidebar.BeforeSidebarRenderedEvent;
import com.atlassian.jira.projects.sidebar.footer.ProjectAdminLinkService;
import com.atlassian.jira.projects.util.FlushHeadEarlyService;
import com.atlassian.jira.projects.util.OptionalServiceRef;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredData;
import com.atlassian.webresource.api.assembler.RequiredResources;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ProjectSidebarRendererImpl
implements ProjectSidebarRenderer {
    public static final String SHOULD_DISPLAY_CHAPERONE = "should-display-chaperone";
    private static final String PROJECT_SETTINGS_NEW_SIDEBAR_LOCATION = "sd.new.settings.sidebar.location";
    private static final String PROJECT_SIDEBAR_DEFER_RESOURCES = "com.atlassian.jira.projects.sidebar.DEFER_RESOURCES";
    private static final String PROJECT_SIDEBAR_DEFER_RESOURCES_KILLSWITCH = "com.atlassian.jira.projects.sidebar.DEFER_RESOURCES_KILLSWITCH";
    private static final String PROJECT_SIDEBAR_CONTEXT = "jira.project.sidebar";
    private final ProjectHeaderRenderer projectHeaderRenderer;
    private final ProjectContentRendererRegistry contentRendererRegistry;
    private final SidebarRenderer sidebarRenderer;
    private final ProjectAdminLinkService adminLinkProvider;
    private final ProjectService projectService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PageBuilderService pageBuilderService;
    private final OnboardingServiceAccessor onboardingServiceAccessor;
    private final EventPublisher eventPublisher;
    private final CurrentProjectService currentProjectService;
    private final FlushHeadEarlyService flushHeadEarlyService;
    private final FeatureManager featureManager;

    @Autowired
    public ProjectSidebarRendererImpl(ProjectHeaderRenderer projectHeaderRenderer, ProjectContentRendererRegistry contentRendererRegistry, SidebarRenderer sidebarRenderer, ProjectAdminLinkService adminLinkProvider, ProjectService projectService, JiraAuthenticationContext jiraAuthenticationContext, JiraPageBuilderService pageBuilderService, OnboardingServiceAccessor onboardingServiceAccessor, @ComponentImport EventPublisher eventPublisher, CurrentProjectService currentProjectService, FlushHeadEarlyService flushHeadEarlyService, @ComponentImport FeatureManager featureManager) {
        this.projectHeaderRenderer = projectHeaderRenderer;
        this.contentRendererRegistry = contentRendererRegistry;
        this.sidebarRenderer = sidebarRenderer;
        this.adminLinkProvider = adminLinkProvider;
        this.projectService = projectService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.pageBuilderService = pageBuilderService;
        this.onboardingServiceAccessor = onboardingServiceAccessor;
        this.eventPublisher = eventPublisher;
        this.currentProjectService = currentProjectService;
        this.flushHeadEarlyService = flushHeadEarlyService;
        this.featureManager = featureManager;
    }

    public String render(Project project, String selectedItemId) {
        if (!this.flushHeadEarlyService.isFlushHeadEarly()) {
            this.requireResources(project, selectedItemId);
        }
        this.addChaperoneData();
        this.eventPublisher.publish((Object)new BeforeSidebarRenderedEvent(project, selectedItemId));
        this.currentProjectService.setCurrentProject(project.getKey());
        Option<SettingsButton> settingsButton = Option.none();
        if (!this.featureManager.isEnabled(PROJECT_SETTINGS_NEW_SIDEBAR_LOCATION)) {
            settingsButton = this.adminLinkProvider.getLinkForProject(project, selectedItemId);
        }
        return project != null && project.isArchived() ? this.sidebarRenderer.renderHidden() : this.sidebarRenderer.render(() -> this.contentRendererRegistry.getRenderer(project.getProjectTypeKey()).render(project, selectedItemId), () -> this.projectHeaderRenderer.render(project, selectedItemId), settingsButton);
    }

    public Either<ErrorCollection, String> render(String projectKey, String selectedItemId) {
        ProjectService.GetProjectResult result = this.projectService.getProjectByKey(this.jiraAuthenticationContext.getUser(), projectKey);
        if (result.isValid()) {
            return Either.right((Object)this.render(result.getProject(), selectedItemId));
        }
        return Either.left((Object)result.getErrorCollection());
    }

    public void requireResources(Project project, String selectedItemId) {
        this.addProjectData(project);
    }

    private void addProjectData(Project project) {
        boolean deferResources;
        ProjectTypeKey projectTypeKey = project.getProjectTypeKey();
        RequiredData data = this.pageBuilderService.assembler().data();
        RequiredResources resources = this.pageBuilderService.assembler().resources();
        data.requireData("project-id", (Number)project.getId()).requireData("project-key", project.getKey()).requireData("project-name", project.getName());
        boolean bl = deferResources = this.featureManager.isEnabled(PROJECT_SIDEBAR_DEFER_RESOURCES) && !this.featureManager.isEnabled(PROJECT_SIDEBAR_DEFER_RESOURCES_KILLSWITCH);
        if (!deferResources) {
            resources.requireContext(PROJECT_SIDEBAR_CONTEXT);
        }
        if (projectTypeKey != null) {
            data.requireData("project-type", projectTypeKey.getKey());
            if (!deferResources) {
                resources.requireContext("jira.project.sidebar." + projectTypeKey.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChaperoneData() {
        OptionalServiceRef onboardingService = this.onboardingServiceAccessor.obtain();
        try {
            RequiredData requiredData = this.pageBuilderService.assembler().data();
            if (onboardingService.isAvailable()) {
                ApplicationUser user = this.jiraAuthenticationContext.getUser();
                boolean shouldDisplayChaperone = user != null && ((OnboardingService)onboardingService.get()).getStartedFirstUseFlowKey(user) == null;
                requiredData.requireData(SHOULD_DISPLAY_CHAPERONE, Boolean.valueOf(shouldDisplayChaperone));
            } else {
                requiredData.requireData(SHOULD_DISPLAY_CHAPERONE, Boolean.valueOf(false));
            }
        }
        finally {
            onboardingService.release();
        }
    }
}

