/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.servlet;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.web.servlet.api.ServletForwarder;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

@Scanned
public class ReKeyedProjectFilter
extends AbstractHttpFilter {
    private final ProjectService projectService;
    private final ServletForwarder forwarder;

    public ReKeyedProjectFilter(ProjectService projectService, @ComponentImport ServletForwarder forwarder) {
        this.projectService = projectService;
        this.forwarder = forwarder;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String[] pathSegments = StringUtils.split((String)request.getServletPath(), (String)"/");
        if (pathSegments.length == 1) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String requestedKey = pathSegments[1];
        String canonicalProjectKey = (String)this.getCanonicalProjectKey(requestedKey).getOrElse((Object)requestedKey);
        if (canonicalProjectKey.equals(requestedKey)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        pathSegments[1] = canonicalProjectKey;
        UrlBuilder url = new UrlBuilder("/", false);
        for (String segment : pathSegments) {
            url.addPath(segment);
        }
        Map parameterMap = request.getParameterMap();
        for (Map.Entry parameter : parameterMap.entrySet()) {
            for (String parameterValue : (String[])parameter.getValue()) {
                url.addParameter((String)parameter.getKey(), parameterValue);
            }
        }
        this.forwarder.forward(request, response, url.asURI());
    }

    private Option<String> getCanonicalProjectKey(String projectKey) {
        Either<ErrorCollection, Project> getProjectResult = this.projectService.getProject(projectKey);
        if (getProjectResult.isLeft()) {
            return Option.none();
        }
        return Option.some((Object)((Project)getProjectResult.right().get()).getKey());
    }
}

