/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.release;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.page.release.VersionReleaseStatusView;
import com.atlassian.jira.projects.page.release.VersionService;
import com.atlassian.jira.projects.page.release.VersionToVersionViewTransformer;
import com.atlassian.jira.projects.page.release.VersionView;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="project/{projectKey}/release")
public class ReleasePageResource {
    private static final Logger log = LoggerFactory.getLogger(ReleasePageResource.class);
    private final ProjectService projectService;
    private final VersionService versionService;
    private final VersionToVersionViewTransformer versionToVersionView;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private static final JsonFactory JSON = new MappingJsonFactory();

    @Autowired
    public ReleasePageResource(ProjectService projectService, VersionService versionService, VersionToVersionViewTransformer versionToVersionView, JiraAuthenticationContext jiraAuthenticationContext) {
        this.projectService = projectService;
        this.versionService = versionService;
        this.versionToVersionView = versionToVersionView;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    @Path(value="allversions")
    @AnonymousAllowed
    public Response getAllVersionsForProject(@PathParam(value="projectKey") String projectKey) {
        log.debug("Requesting version list with data about corresponding issues.");
        return this.getAllProjectVersions(projectKey, true);
    }

    @GET
    @Path(value="versions")
    @AnonymousAllowed
    public Response getVersionsForProject(@PathParam(value="projectKey") String projectKey) {
        Either<ErrorCollection, Project> project = this.projectService.getProject(projectKey);
        if (project.isRight()) {
            List versions = (List)this.versionService.getUnarchivedVersions((Project)project.right().get()).getOrElse((Object)ImmutableList.of());
            ImmutableList versionViews = ImmutableList.copyOf((Collection)versions.stream().map(v -> this.versionToVersionView.getView((Version)v)).collect(Collectors.toList()));
            return Response.ok((Object)versionViews).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)((ErrorCollection)project.left().get()).getErrorMessages()).build();
    }

    @GET
    @Path(value="allversions-nodetails")
    @AnonymousAllowed
    public Response getAllVersionsWithoutIssuesForProject(@PathParam(value="projectKey") String projectKey) {
        log.debug("Requesting version list without data about corresponding issues.");
        return this.getAllProjectVersions(projectKey, false);
    }

    private Response getAllProjectVersions(String projectKey, boolean shouldGetIssuesData) {
        Either<ErrorCollection, Project> project = this.projectService.getProject(projectKey);
        if (project.isRight()) {
            StreamingOutput out = outputStream -> {
                try (JsonGenerator jsGen = this.jsonGeneratorCreator(outputStream);){
                    jsGen.writeStartArray();
                    jsGen.flush();
                    ((List)this.versionService.getVersions((Project)project.right().get()).getOrElse((Object)ImmutableList.of())).stream().map(v -> this.versionToVersionView.getView((Version)v, shouldGetIssuesData)).forEach(v -> this.writeObjectToJGenerator(jsGen, (VersionView)v));
                    jsGen.writeEndArray();
                }
                catch (IOException e) {
                    log.warn(String.format("Exception while streaming versions for project: %s", projectKey), (Throwable)e);
                }
                catch (WriteObjectToJGeneratorIOException e) {
                    log.warn(String.format("Exception while streaming versions for project: %s", projectKey), (Throwable)((Object)e));
                }
            };
            return Response.ok((Object)out).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)((ErrorCollection)project.left().get()).getErrorMessages()).build();
    }

    JsonGenerator jsonGeneratorCreator(OutputStream outputStream) throws IOException {
        return JSON.createJsonGenerator(outputStream, JsonEncoding.UTF8);
    }

    private void writeObjectToJGenerator(JsonGenerator jsonGenerator, VersionView vv) {
        try {
            jsonGenerator.writeObject((Object)vv);
        }
        catch (IOException ex) {
            throw new WriteObjectToJGeneratorIOException(ex);
        }
    }

    @GET
    @Path(value="/details/{versionId}")
    @AnonymousAllowed
    public Response getDetails(@PathParam(value="versionId") Long versionId) {
        Option<Version> version = this.versionService.getVersion(versionId);
        if (version.isDefined()) {
            return Response.ok((Object)version.map(v -> this.versionToVersionView.getView((Version)v)).get()).cacheControl(CacheControl.never()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private Response checkPermissionToViewVersions(String projectKey) {
        Either<ErrorCollection, Project> project = this.projectService.getProject(projectKey);
        if (((Boolean)project.toOption().map(f -> !this.versionService.canViewVersions((Project)f)).getOrElse((Object)true)).booleanValue()) {
            if (this.jiraAuthenticationContext.getLoggedInUser() == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (project.isLeft()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)((ErrorCollection)project.left().get()).getReasons()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/details/progress")
    @AnonymousAllowed
    public Response getVersionProgress(List<String> versionIds, @PathParam(value="projectKey") String projectKey) {
        Response permissionCheckResponse = this.checkPermissionToViewVersions(projectKey);
        if (permissionCheckResponse.getStatus() != Response.Status.OK.getStatusCode()) {
            return permissionCheckResponse;
        }
        HashMap<String, VersionReleaseStatusView> responseCollection = new HashMap<String, VersionReleaseStatusView>();
        for (String versionId : versionIds) {
            Long versionLongId;
            try {
                versionLongId = Long.parseUnsignedLong(versionId);
            }
            catch (NumberFormatException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Option<Version> version = this.versionService.getVersion(versionLongId);
            if (version.isDefined() && ((Version)version.get()).getProject().getKey().equals(projectKey)) {
                responseCollection.put(versionId, this.versionToVersionView.getStatus((Version)version.get()));
                continue;
            }
            log.debug("Skipped version while requesting progress data. Version with ID " + versionLongId + " does not exist in the project.");
        }
        return Response.ok(responseCollection).build();
    }

    private class WriteObjectToJGeneratorIOException
    extends RuntimeIOException {
        public WriteObjectToJGeneratorIOException(IOException cause) {
            super(cause);
        }
    }
}

