/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.components;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.URLEncoder;
import com.atlassian.jira.projects.page.AbstractProjectsPageContextProvider;
import com.atlassian.jira.projects.page.components.AssigneeSelectContextProvider;
import com.atlassian.jira.projects.page.components.ComponentService;
import com.atlassian.jira.projects.page.components.ComponentToComponentViewTransformer;
import com.atlassian.jira.projects.page.components.ComponentView;
import com.atlassian.jira.projects.util.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@Scanned
public class ComponentsPageContextProvider
extends AbstractProjectsPageContextProvider {
    protected static final String RENDER_LEGACY = "renderLegacy";
    private static final String JIRA_PROJECT_COMPONENTS_CONTEXT = "jira.project.components";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectPermissions projectPermissions;
    private final ComponentService componentService;
    private final PageBuilderService pageBuilderService;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    private final HelpUrls helpUrls;
    private final ComponentToComponentViewTransformer componentToComponentView;
    private final AssigneeSelectContextProvider assigneeSelectContextProvider;
    private final FeatureManager featureManager;

    public ComponentsPageContextProvider(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport JaxbJsonMarshaller jaxbJsonMarshaller, ComponentService componentService, ProjectPermissions projectPermissions, @ComponentImport JiraPageBuilderService pageBuilderService, HelpUrls helpUrls, AssigneeSelectContextProvider assigneeSelectContextProvider, FeatureManager featureManager, ComponentToComponentViewTransformer componentToComponentView) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
        this.componentService = componentService;
        this.projectPermissions = projectPermissions;
        this.pageBuilderService = pageBuilderService;
        this.helpUrls = helpUrls;
        this.assigneeSelectContextProvider = assigneeSelectContextProvider;
        this.componentToComponentView = componentToComponentView;
        this.featureManager = featureManager;
    }

    @Override
    public void init(Map<String, String> params) throws PluginParseException {
    }

    @Override
    protected Map<String, Object> getContextMap(Project project, Map<String, Object> originalContext) {
        Stream.of(JIRA_PROJECT_COMPONENTS_CONTEXT, "jira.project.sidebar").forEach(ctx -> this.pageBuilderService.assembler().resources().requireContext(ctx));
        boolean isProjectAdmin = this.projectPermissions.hasProjectAdminPermission(this.jiraAuthenticationContext.getLoggedInUser(), project);
        this.includeWebResources();
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.page.components:project", project.getKey());
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.page.components:projectId", (Number)project.getId());
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.page.components:projectAdmin", Boolean.valueOf(isProjectAdmin));
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.page.components:components", this.getComponentsJsonable(project));
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.page.components:learnMoreUrl", this.helpUrls.getUrl("component_management").getUrl());
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.page.components:assigneeSelectParams", writer -> {
            try {
                new JSONObject(this.assigneeSelectContextProvider.getParameters(project)).write(writer);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        });
        ImmutableMap.Builder contextMap = ImmutableMap.builder();
        if (isProjectAdmin) {
            contextMap.put((Object)"adminLink", (Object)("plugins/servlet/project-config/" + URLEncoder.encodePathSegment(project.getKey()) + "/components"));
        }
        if (originalContext.containsKey(RENDER_LEGACY)) {
            contextMap.put((Object)RENDER_LEGACY, originalContext.get(RENDER_LEGACY));
        }
        return contextMap.build();
    }

    private void includeWebResources() {
        this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.jira.jira-projects-plugin:components-page-init");
    }

    @VisibleForTesting
    Jsonable getComponentsJsonable(Project project) {
        return writer -> writer.append(this.jaxbJsonMarshaller.marshal(this.getComponents(project)));
    }

    @VisibleForTesting
    List<ComponentView> getComponents(Project project) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)((Iterable)this.componentService.getComponents(project).getOrElse((Object)ImmutableList.of())), this.componentToComponentView.componentToComponentView(project)));
    }
}

