/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.components;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.projects.util.AssigneeType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement
public class ComponentView {
    @XmlElement
    private final long id;
    @XmlElement
    private final String name;
    @XmlElement
    private final long issuesCount;
    @XmlElement
    private final String issuesUrl;
    @XmlElement
    private final String leadUserDisplayName;
    @XmlElement
    private final String leadUserProfileLinkHtml;
    @XmlElement
    private final String description;
    @XmlElement
    private final String project;
    @XmlElement
    private final String assigneeType;
    @XmlElement
    private final boolean archived;

    public ComponentView(ProjectComponent component, String leadUserDisplayName, String leadUserProfileLinkHtml, Long issuesCount, String issuesUrl, String projectKey) {
        this.id = component.getId();
        this.name = component.getName();
        this.issuesCount = issuesCount;
        this.issuesUrl = issuesUrl;
        this.leadUserDisplayName = StringUtils.stripToEmpty((String)leadUserDisplayName);
        this.leadUserProfileLinkHtml = StringUtils.stripToEmpty((String)leadUserProfileLinkHtml);
        this.description = component.getDescription();
        this.project = projectKey;
        this.assigneeType = AssigneeType.valueOf(component.getAssigneeType()).name();
        this.archived = component.isArchived();
    }

    public String getIssuesUrl() {
        return this.issuesUrl;
    }

    public String getName() {
        return this.name;
    }

    public long getIssuesCount() {
        return this.issuesCount;
    }

    public String getLeadUserDisplayName() {
        return this.leadUserDisplayName;
    }

    public String getLeadUserProfileLinkHtml() {
        return this.leadUserProfileLinkHtml;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProject() {
        return this.project;
    }

    public long getId() {
        return this.id;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentView)) {
            return false;
        }
        ComponentView that = (ComponentView)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.issuesCount != that.issuesCount) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.issuesUrl != null ? !this.issuesUrl.equals(that.issuesUrl) : that.issuesUrl != null) {
            return false;
        }
        if (this.leadUserDisplayName != null ? !this.leadUserDisplayName.equals(that.leadUserDisplayName) : that.leadUserDisplayName != null) {
            return false;
        }
        if (this.leadUserProfileLinkHtml != null ? !this.leadUserProfileLinkHtml.equals(that.leadUserProfileLinkHtml) : that.leadUserProfileLinkHtml != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.project != null ? !this.project.equals(that.project) : that.project != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (int)(this.issuesCount ^ this.issuesCount >>> 32);
        result = 31 * result + (this.issuesUrl != null ? this.issuesUrl.hashCode() : 0);
        result = 31 * result + (this.leadUserDisplayName != null ? this.leadUserDisplayName.hashCode() : 0);
        result = 31 * result + (this.leadUserProfileLinkHtml != null ? this.leadUserProfileLinkHtml.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
        return result;
    }
}

