/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.impl;

import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.ProjectTabPanelFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.IssueFiltersFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.NoIssuesFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.StatusSummaryFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.UnresolvedIssuesByAssigneeFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.UnresolvedIssuesByComponentFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.UnresolvedIssuesByFixVersionFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.UnresolvedIssuesByIssueTypeFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.UnresolvedIssuesByPriorityFragment;
import com.atlassian.jira.projects.legacy.projectpanel.impl.AbstractFragmentBasedProjectTabPanel;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@Scanned
public class IssuesProjectTabPanel
extends AbstractFragmentBasedProjectTabPanel {
    private final UnresolvedIssuesByPriorityFragment unresolvedIssuesByPriorityFragment;
    private final UnresolvedIssuesByAssigneeFragment unresolvedIssuesByAssigneeFragment;
    private final UnresolvedIssuesByFixVersionFragment unresolvedIssuesByFixVersionFragment;
    private final StatusSummaryFragment statusSummaryFragment;
    private final UnresolvedIssuesByComponentFragment unresolvedIssuesByComponentFragment;
    private final UnresolvedIssuesByIssueTypeFragment unresolvedIssuesByIssueTypeFragment;
    private final IssueFiltersFragment issueFiltersFragment;
    private final NoIssuesFragment noIssuesFragment;
    private final SearchProvider searchProvider;

    @Inject
    public IssuesProjectTabPanel(UnresolvedIssuesByPriorityFragment unresolvedIssuesByPriorityFragment, UnresolvedIssuesByAssigneeFragment unresolvedIssuesByAssigneeFragment, UnresolvedIssuesByFixVersionFragment unresolvedIssuesByFixVersionFragment, StatusSummaryFragment statusSummaryFragment, UnresolvedIssuesByComponentFragment unresolvedIssuesByComponentFragment, UnresolvedIssuesByIssueTypeFragment unresolvedIssuesByIssueTypeFragment, IssueFiltersFragment issueFiltersFragment, NoIssuesFragment noIssuesFragment, @ComponentImport SearchProvider searchProvider) {
        this.unresolvedIssuesByPriorityFragment = unresolvedIssuesByPriorityFragment;
        this.unresolvedIssuesByAssigneeFragment = unresolvedIssuesByAssigneeFragment;
        this.unresolvedIssuesByFixVersionFragment = unresolvedIssuesByFixVersionFragment;
        this.statusSummaryFragment = statusSummaryFragment;
        this.unresolvedIssuesByComponentFragment = unresolvedIssuesByComponentFragment;
        this.unresolvedIssuesByIssueTypeFragment = unresolvedIssuesByIssueTypeFragment;
        this.issueFiltersFragment = issueFiltersFragment;
        this.noIssuesFragment = noIssuesFragment;
        this.searchProvider = searchProvider;
    }

    @Override
    protected List<ProjectTabPanelFragment> getTopFragments(BrowseContext ctx) {
        if (this.doesProjectHaveIssues(ctx)) {
            return Arrays.asList(this.issueFiltersFragment);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<ProjectTabPanelFragment> getLeftColumnFragments(BrowseContext ctx) {
        ArrayList<ProjectTabPanelFragment> frags = new ArrayList<ProjectTabPanelFragment>();
        if (this.doesProjectHaveIssues(ctx)) {
            frags.add(this.unresolvedIssuesByPriorityFragment);
            frags.add(this.unresolvedIssuesByAssigneeFragment);
            frags.add(this.unresolvedIssuesByFixVersionFragment);
        } else {
            frags.add(this.noIssuesFragment);
        }
        return frags;
    }

    @Override
    protected List<ProjectTabPanelFragment> getRightColumnFragments(BrowseContext ctx) {
        ArrayList<ProjectTabPanelFragment> frags = new ArrayList<ProjectTabPanelFragment>();
        if (this.doesProjectHaveIssues(ctx)) {
            frags.add(this.statusSummaryFragment);
            frags.add(this.unresolvedIssuesByComponentFragment);
            frags.add(this.unresolvedIssuesByIssueTypeFragment);
        }
        return frags;
    }

    @Override
    public boolean showPanel(BrowseContext ctx) {
        return true;
    }

    private boolean doesProjectHaveIssues(BrowseContext ctx) {
        Query query = ctx.createQuery();
        try {
            long count = this.searchProvider.getHitCount(SearchQuery.create((Query)query, (ApplicationUser)ctx.getUser()));
            return count > 0L;
        }
        catch (SearchException e) {
            return true;
        }
    }
}

