AJS.namespace("JIRA.Projects.Util");

(function () {
    var queryStringFrom = function (url) {
        return url.split('?')[1] || '';
    };

    var accumulateQueryParameter = function(parsedQuery, keyAndValueString) {
        var keyAndValue = keyAndValueString.split('=');
        parsedQuery[keyAndValue[0]] = keyAndValue[1];
        return parsedQuery;
    };

    var queryStringToObject = function (url) {
        var queryStringKeyAndValues = _.compact(queryStringFrom(url).split('&'));
        return _(queryStringKeyAndValues).reduce(accumulateQueryParameter, {});
    };

    /**
     * Transforms the provided url to point to the new selected tab.
     *
     * @param {string} url
     * @return the id of the selected tab from the url's query string, or null if there is none in the query string
     */
    JIRA.Projects.Util.extractSelectedTab = function (url) {
        return queryStringToObject(url).selectedTab || null;
    };

    /**
     * @param {string} url
     * @param {JIRA.Projects.TabModel} selectedTabValue
     * @return string url pointing to the selected tab value specified, with other parameters left intact
     */
    JIRA.Projects.Util.setSelectedTab = function (url, selectedTabValue) {
        var query = queryStringToObject(url);
        query.selectedTab = selectedTabValue;
        return '?' + decodeURIComponent(AJS.$.param(query));
    };
})();