AJS.test.require("com.atlassian.jira.jira-projects-plugin:browseproject", function() {

    module("JIRA.Projects.TabView", {
        setup: function () {
            this.model = new JIRA.Projects.TabModel({html: "the content"});
            this.sandbox = sinon.sandbox.create();
        },
        teardown: function() {
            this.sandbox.restore();
        }
    });

    test("re-renders on tab switch event", function () {
        this.sandbox.stub(JIRA.Projects.Util, "extractSelectedTab");
        var el = jQuery('<div><div id="project-tab"></div></div>');
        new JIRA.Projects.TabView({model: this.model, el: el});

        this.model.trigger("switch");

        equal(el.html(), '<div id="project-tab">the content</div>', "New html blatted into the project tab");
    });

    test("updates selected tab on tab switch event", function () {
        var links = '<ul class="aui-page-panel-nav"><li><a href="http://jira.url/browse/PROJECTKEY?selectedTab=this.tab"></a></li>' +
                '<li class="active"><a href="http://jira.url/browse/PROJECTKEY?selectedTab=not.this.tab"></a></li>';
        var $el = jQuery('<div>' + links + '<div id="project-tab"></div></div>');

        this.model._url = 'http://jira.url/secure/oldBrowseProject.jspa?id=123&selectedTab=this.tab&foo=bar';
        new JIRA.Projects.TabView({
            el: $el,
            model: this.model
        });
        this.model.trigger('switch');

        var $activeLinks = $el.find('li.active > a');
        equal($activeLinks.length, 1, 'only one link set to active');
        equal($activeLinks.attr('href'), 'http://jira.url/browse/PROJECTKEY?selectedTab=this.tab',
                'links updated to show new tab selection');
    });

    test("alerts the model of a new tab request when a sidebar link is clicked", function () {
        var $el = jQuery("<div><div class='aui-page-panel-nav'><a href='/sometab'></a></div></div>");
        this.sandbox.stub(this.model, "newTabRequested");

        var view = new JIRA.Projects.TabView({
            el: $el,
            model: this.model
        });
        view.$sidebarLinks.click();

        equal(this.model.newTabRequested.callCount, 1, "Alerts model of new tab request");
        ok(this.model.newTabRequested.calledWithExactly('/sometab'), "Passes new tab's url");
    });

    test("raises new content added event on tab switch", function () {
        this.sandbox.stub(JIRA.Projects.Util, "extractSelectedTab");
        var el = jQuery('<div><div id="project-tab"></div></div>');
        var contentAddedSpy = sinon.spy();

        new JIRA.Projects.TabView({model: this.model, el: el});
        JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, contentAddedSpy);

        this.model.trigger("switch");

        equal(contentAddedSpy.callCount, 1, "new content added raised on tab switch");
        equal(contentAddedSpy.getCall(0).args[1].html(), "the content", "updated element passed with new content added event");
        equal(contentAddedSpy.getCall(0).args[2], JIRA.CONTENT_ADDED_REASON.tabUpdated, "tab update provided as reason for new content added");
    });

});
