AJS.namespace("JIRA.Projects");

JIRA.Projects.TabView = Backbone.View.extend({
    initialize: function () {
        var model = this.model;
        this.$stage = this.$el.find("#project-tab");
        this.$sidebarLinks = this.$el.find(".aui-page-panel-nav a");

        this.listenTo(model, 'switch', this.render);

        this.$sidebarLinks.click(function (e) {
            model.newTabRequested(AJS.$(this).attr('href'));
            e.preventDefault();
        });
    },

    render: function () {
        this.$stage.html(this.model.get("html"));
        this.updateTabSelection();
        JIRA.trigger(JIRA.Events.NEW_CONTENT_ADDED, [this.$stage, JIRA.CONTENT_ADDED_REASON.tabUpdated]);
    },

    updateTabSelection: function () {
        var tabFrom = JIRA.Projects.Util.extractSelectedTab;
        var newTab = tabFrom(this.model._url);

        this.$sidebarLinks.parent().removeClass("active");
        var $linkForNewTab = this.$sidebarLinks.filter(function () {
            return tabFrom(AJS.$(this).attr('href')) === newTab;
        });

        $linkForNewTab.parent().addClass("active");
    }
});

