AJS.namespace("JIRA.Projects");

JIRA.Projects.TabPanelRouter = Backbone.Router.extend({

    /**
     *
     * @param {JIRA.Projects.TabModel} tabModel
     * @param location the window.location object
     */
    initialize: function(tabModel, location) {
        this.route(/[&?]selectedTab=(.*)(&|$)/, 'loadTab');
        this.tabModel = tabModel;
        this.location = location;
    },

    /**
     *
     * @param tabKey the key of the tab to be loaded
     */
    loadTab: function (tabKey) {
        var OLD_PLUGIN_KEY = "com.atlassian.jira.plugin.system.project",
            NEW_PLUGIN_KEY = "com.atlassian.jira.jira-projects-plugin";

        //redirect to load the correct tab panel in case users have bookmarked the old browse project pages.
        tabKey = tabKey.replace(OLD_PLUGIN_KEY, NEW_PLUGIN_KEY);
        this.tabModel.newTabRequested(this.location.pathname + JIRA.Projects.Util.setSelectedTab(this.location.search, tabKey));
    }

});