AJS.namespace("JIRA.Projects");

JIRA.Projects.TabModel = Backbone.Model.extend({

    parse: function (data) {
        return {
            html: data || ""
        };
    },

    url: function () {
        return this._url + "&decorator=none&contentOnly=true";
    },

    newTabRequested: function (tabUrl) {
        var model = this,
            oldUrl = this._url;
        this._url = tabUrl;
        this.fetch({
            dataType: "text",
            statusCode: {
                // Need to do this instead of passing in a 'success' handler
                // because we don't get access to the request object otherwise
                200: function(body, statusText, request) {
                    if (request.getResponseHeader('X-Atlassian-Dialog-Control') === 'permissionviolation') {
                        // We've been logged out
                        model.trigger("switch-error", { loggedOut: true }, tabUrl);
                    } else {
                        model.trigger("switch", tabUrl);
                    }
                }
            },
            error: function (model, response) {
                model._url = oldUrl;
                model.trigger("switch-error", response, tabUrl);
            }
        });
    }
});
