/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.web;

import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.browse.BrowseProjectContext;
import com.atlassian.jira.projects.web.BrowseProjectContextProvider;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.AbstractPluggableTabPanelAction;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import webwork.action.ServletActionContext;

public class BrowseProject
extends AbstractPluggableTabPanelAction<ProjectTabPanelModuleDescriptor> {
    private static final String LEAD_USER_LINK_ID_PREFIX = "project_summary";
    private static final String PROFILE_LINK_USER_FORMAT_TYPE = "profileLinkWithAvatar";
    public static final String NO_TITLE = "noTitle";
    public static final String SUCCESS_TAB = "successtab";
    private final UserProjectHistoryManager projectHistoryManager;
    private final SimpleLinkManager simpleLinkManager;
    private final UserFormats userFormats;
    private final PageBuilderService pageBuilderService;
    private final BrowseProjectContextProvider browseProjectContextProvider;
    private Long projectId;
    private boolean contentOnly;

    @Inject
    public BrowseProject(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport UserProjectHistoryManager projectHistoryManager, @ComponentImport SimpleLinkManager simpleLinkManager, BrowseProjectContextProvider browseProjectContextProvider, @ComponentImport UserFormats userFormats) {
        super(pluginAccessor);
        super.setPersistenceKey("jira.browse.projects.current.tab");
        this.userFormats = userFormats;
        this.browseProjectContextProvider = browseProjectContextProvider;
        this.pageBuilderService = pageBuilderService;
        this.projectHistoryManager = projectHistoryManager;
        this.simpleLinkManager = simpleLinkManager;
    }

    protected String doExecute() throws Exception {
        try {
            Collection projects;
            Project newProject;
            Project project = this.getProject();
            if (this.projectId != null && (newProject = this.projectManager.getProjectObj(this.projectId)) != null && !newProject.equals(project)) {
                this.log.info((Object)"Specified project id to browse, but it is diff to current project.  Most prob a permission violation (or it doesn't exist)");
                return "permissionviolation";
            }
            if (project == null && (projects = this.getBrowsableProjects()).size() == 1) {
                Project onlyProject = (Project)projects.iterator().next();
                this.setSelectedProject(onlyProject);
            }
            if (this.getProject() == null) {
                return this.getRedirect("/secure/BrowseProjects.jspa");
            }
            this.pageBuilderService.assembler().resources().requireContext("jira.browse").requireContext("jira.browse.project");
            return this.contentOnly ? SUCCESS_TAB : "success";
        }
        catch (IllegalStateException e) {
            this.log.info((Object)"Permissions Exception whilst browsing project", (Throwable)e);
            return "permissionviolation";
        }
    }

    public Long getId() {
        return this.projectId;
    }

    public void setId(Long id) {
        this.projectId = id;
        this.setSelectedProjectId(id);
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    @ActionViewData
    public Project getProject() {
        return this.projectHistoryManager.getCurrentProject(10, this.getLoggedInUser());
    }

    @ActionViewData(value="success")
    public Map<String, Object> getContext() {
        try {
            return this.browseProjectContextProvider.getContext(this.getProject(), this.getSelected());
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Something went wrong getting context for currently selected browse project tab", (Throwable)e);
            throw e;
        }
    }

    @ActionViewData
    public List<ProjectTabPanelModuleDescriptor> getProjectTabPanels() {
        return this.getTabPanels();
    }

    @ActionViewData
    public String getTabLabel() {
        boolean descriptorNoTitle;
        ProjectTabPanelModuleDescriptor tabPanel = (ProjectTabPanelModuleDescriptor)this.getSelectedTabPanel();
        boolean bl = descriptorNoTitle = tabPanel.getParams().containsKey(NO_TITLE) && Boolean.parseBoolean((String)tabPanel.getParams().get(NO_TITLE));
        if (tabPanel != null && !descriptorNoTitle) {
            return tabPanel.getLabel();
        }
        if (tabPanel == null) {
            this.log.warn((Object)"Either unknown tab specified or no tab specified and no tabs in system");
        }
        return null;
    }

    @ActionViewData
    public String getTabHtml() throws IOException {
        ProjectTabPanelModuleDescriptor tabPanelDescriptor = (ProjectTabPanelModuleDescriptor)this.getSelectedTabPanel();
        if (tabPanelDescriptor == null) {
            this.log.warn((Object)("Unknown tab panel '" + this.getSelectedTab() + "' has been specified."));
            return "";
        }
        ProjectTabPanel panel = (ProjectTabPanel)tabPanelDescriptor.getModule();
        if (panel.showPanel(this.getBrowseContext())) {
            return panel.getHtml(this.getBrowseContext());
        }
        this.log.warn((Object)"Tab panel should be hidden.");
        return "";
    }

    @ActionViewData
    public List<SimpleLink> getOperationLinks() {
        return this.simpleLinkManager.getLinksForSection("system.browse.project.operations", this.getLoggedInUser(), this.getJiraHelper());
    }

    @ActionViewData
    public String getProjectLeadHtml() {
        return this.userFormats.formatter(PROFILE_LINK_USER_FORMAT_TYPE).formatUserkey(this.getProject().getLeadUserKey(), LEAD_USER_LINK_ID_PREFIX);
    }

    @ActionViewData
    public List<Map<String, Object>> getAdminNavLinks() {
        return this.getSoyListOfLinksForSection("atj.jira.proj.nav.switcher/project-navswitcher");
    }

    @ActionViewData
    public List<Map<String, Object>> getAdminNavLinksSecondary() {
        return this.getSoyListOfLinksForSection("atj.jira.proj.nav.switcher/project-navswitcher-secondary");
    }

    @ActionViewData
    public String getAdministratorContactLink() {
        return super.getAdministratorContactLink();
    }

    protected List<ProjectTabPanelModuleDescriptor> getTabPanelModuleDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectTabPanelModuleDescriptor.class);
    }

    protected boolean isTabPanelHidden(ProjectTabPanelModuleDescriptor descriptor) throws PermissionException {
        return !((ProjectTabPanel)descriptor.getModule()).showPanel(this.getBrowseContext());
    }

    private BrowseContext getBrowseContext() {
        return new BrowseProjectContext(this.getLoggedInUser(), this.getProject());
    }

    private JiraHelper getJiraHelper() {
        HashMap<String, String> params = new HashMap<String, String>();
        Project project = this.getSelectedProjectObject();
        String projectKey = project == null ? "" : project.getKey();
        params.put("projectKey", projectKey);
        params.put("projectKeyEncoded", JiraUrlCodec.encode((String)projectKey, (boolean)true));
        return new JiraHelper(ServletActionContext.getRequest(), project, params);
    }

    private List<Map<String, Object>> getSoyListOfLinksForSection(String sectionPath) {
        List projectAdminLinks = this.simpleLinkManager.getLinksForSection(sectionPath, this.getLoggedInUser(), this.getJiraHelper());
        ArrayList<Map<String, Object>> soyedMainLinkSections = new ArrayList<Map<String, Object>>();
        for (SimpleLink currentLink : projectAdminLinks) {
            HashMap<String, Object> soyedSection = new HashMap<String, Object>();
            String id = currentLink.getId();
            soyedSection.put("id", id);
            soyedSection.put("link", currentLink.getUrl());
            soyedSection.put("label", currentLink.getLabel());
            soyedSection.put("isSelected", id.equalsIgnoreCase("browse_project"));
            if (StringUtils.isNotEmpty((String)currentLink.getStyleClass())) {
                soyedSection.put("styleClass", currentLink.getStyleClass());
            }
            soyedMainLinkSections.add(soyedSection);
        }
        return soyedMainLinkSections;
    }
}

