/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.servlet.page;

import com.atlassian.fugue.Option;
import com.atlassian.jira.projects.entity.ProjectPanelContext;
import com.atlassian.jira.projects.servlet.component.PanelRenderer;
import com.atlassian.jira.projects.servlet.component.sidebar.SidebarRenderer;
import com.atlassian.jira.projects.util.TemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectPageRenderer {
    public static final String MODULE_NAME = "com.atlassian.jira.jira-projects-plugin:project-page";
    public static final String TEMPLATE_NAME = "JIRA.Templates.Projects.project";
    private final TemplateRenderer templateRenderer;
    private final SidebarRenderer sidebarRenderer;
    private PanelRenderer panelRenderer;
    private final PageBuilderService pageBuilderService;

    @Autowired
    public ProjectPageRenderer(TemplateRenderer templateRenderer, SidebarRenderer sidebarRenderer, PanelRenderer panelRenderer, PageBuilderService pageBuilderService) {
        this.templateRenderer = templateRenderer;
        this.sidebarRenderer = sidebarRenderer;
        this.panelRenderer = panelRenderer;
        this.pageBuilderService = pageBuilderService;
    }

    public Option<String> render(ProjectPanelContext projectPanelContext) {
        Option<String> content = this.panelRenderer.render(projectPanelContext);
        if (content.isDefined()) {
            this.pageBuilderService.assembler().resources().requireContext("jira.projects.general");
            ImmutableMap data = ImmutableMap.builder().put((Object)"sidebarContent", (Object)this.sidebarRenderer.render()).put((Object)"content", content.get()).build();
            return Option.some((Object)this.templateRenderer.render(MODULE_NAME, TEMPLATE_NAME, (Map<String, Object>)data));
        }
        return Option.none();
    }
}

