/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.jira.plugin.versionpanel.BrowseVersionContext;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.MenuFragment;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;

@Named
public class ReleaseNotesMenuFragment
implements MenuFragment {
    private static final Logger log = Logger.getLogger(ReleaseNotesMenuFragment.class);
    final VelocityRequestContextFactory requestContextFactory;

    @Inject
    public ReleaseNotesMenuFragment(@ComponentImport VelocityRequestContextFactory requestContextFactory) {
        this.requestContextFactory = requestContextFactory;
    }

    @Override
    public String getId() {
        return "release-notes-lnk";
    }

    @Override
    public String getHtml(BrowseContext ctx) {
        VelocityRequestContext velocityRequestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        String baseUrl = velocityRequestContext.getBaseUrl();
        I18nBean i18n = new I18nBean(ctx.getUser());
        try {
            BrowseVersionContext versionContext = (BrowseVersionContext)ctx;
            return "<a id=\"release-notes-lnk\" class=\"lnk\"href=\"" + baseUrl + "/secure/ReleaseNote.jspa?projectId=" + ctx.getProject().getId() + "&version=" + versionContext.getVersion().getId() + "\">" + i18n.getText("common.concepts.releasenotes") + "</a>";
        }
        catch (ClassCastException e) {
            log.error((Object)"The supplied context must be of type BrowseVersionContext", (Throwable)e);
            throw new IllegalArgumentException("The supplied context must be of type BrowseVersionContext", e);
        }
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return true;
    }
}

