/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.ProjectTabPanelFragment;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraVelocityUtils;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public abstract class AbstractFragment
implements ProjectTabPanelFragment {
    protected static final Logger log = Logger.getLogger(AbstractFragment.class);
    protected final VelocityTemplatingEngine velocityManager;
    protected final JiraAuthenticationContext authenticationContext;

    protected AbstractFragment(VelocityTemplatingEngine templatingEngine, JiraAuthenticationContext authenticationContext) {
        this.velocityManager = templatingEngine;
        this.authenticationContext = authenticationContext;
    }

    protected abstract String getTemplateDirectoryPath();

    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map velocityParams = JiraVelocityUtils.getDefaultVelocityParams((JiraAuthenticationContext)this.authenticationContext);
        velocityParams.put("fragid", this.getId());
        velocityParams.put("i18n", this.authenticationContext.getI18nHelper());
        velocityParams.put("browseContext", ctx);
        velocityParams.putAll(ctx.createParameterMap());
        return velocityParams;
    }

    @Override
    public String getHtml(BrowseContext ctx) {
        String template = this.getId() + ".vm";
        try {
            Map<String, Object> velocityParams = this.createVelocityParams(ctx);
            return this.velocityManager.render(TemplateSources.file((String)(this.getTemplateDirectoryPath() + template))).applying(velocityParams).asHtml();
        }
        catch (VelocityException e) {
            log.error((Object)("Error occurred while rendering velocity template for '" + this.getTemplateDirectoryPath() + template + "'."), (Throwable)e);
            return "";
        }
    }

    protected long getIssueCountInSearch(BrowseContext ctx) {
        try {
            return ((SearchProvider)ComponentAccessor.getComponent(SearchProvider.class)).searchCount(ctx.createQuery(), this.authenticationContext.getLoggedInUser());
        }
        catch (SearchException e) {
            return 0L;
        }
    }
}

