/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.releases;

import com.atlassian.jira.pageobjects.components.CalendarPicker;
import com.atlassian.jira.pageobjects.form.FormUtils;
import com.atlassian.jira.pageobjects.pages.AbstractJiraPage;
import com.atlassian.jira.pageobjects.util.TraceContext;
import com.atlassian.jira.pageobjects.util.Tracer;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import org.openqa.selenium.By;

public class VersionEditPage
extends AbstractJiraPage {
    @Inject
    PageBinder binder;
    @Inject
    TraceContext tracerContext;
    @ElementBy(id="version-edit")
    PageElement form;
    private CalendarPicker dateStarted;
    private CalendarPicker dateRelease;
    @ElementBy(id="version-name")
    PageElement name;
    @ElementBy(id="version-description")
    PageElement description;
    @ElementBy(id="version-save-submit")
    PageElement save;
    @ElementBy(id="version-edit-cancel")
    PageElement cancel;
    @ElementBy(cssSelector="div.aui-message-success")
    PageElement divSuccessMessage;
    @ElementBy(cssSelector="div.aui-message.error")
    PageElement divGlobalError;
    private final Long versionId;
    private String projectKey;

    public VersionEditPage(Long versionId, String projectKey) {
        this.versionId = versionId;
        this.projectKey = projectKey;
    }

    @Init
    public void init() {
        this.dateStarted = (CalendarPicker)this.pageBinder.bind(CalendarPicker.class, new Object[]{By.cssSelector((String)"input[name=userStartDate]"), By.cssSelector((String)"input[name=userStartDate]+a>span.aui-iconfont-calendar")});
        this.dateRelease = (CalendarPicker)this.pageBinder.bind(CalendarPicker.class, new Object[]{By.cssSelector((String)"input[name=userReleaseDate]"), By.cssSelector((String)"input[name=userReleaseDate]+a>span.aui-iconfont-calendar")});
    }

    public TimedCondition isAt() {
        return Conditions.or((TimedQuery[])new TimedQuery[]{this.save.timed().isVisible(), this.hasGlobalError()});
    }

    public String getUrl() {
        return "/secure/VersionEdit!default.jspa?versionId=" + this.versionId;
    }

    public VersionEditPage save() {
        Tracer tracer = this.tracerContext.checkpoint();
        VersionEditPage editPage = this.save(VersionEditPage.class, this.versionId, this.projectKey);
        this.tracerContext.waitFor(tracer, "jira.version.edit.save.done");
        return editPage;
    }

    public <T> T save(Class<T> bindClass, Object ... bindParams) {
        this.save.click();
        return (T)this.pageBinder.bind(bindClass, bindParams);
    }

    public <T> T cancel(Class<T> bindClass, Object ... bindParams) {
        this.cancel.click();
        return (T)this.pageBinder.bind(bindClass, bindParams);
    }

    public void saveDialog() {
        Tracer tracer = this.tracerContext.checkpoint();
        this.save.click();
        this.tracerContext.waitFor(tracer, "jira.version.edit.save.done");
    }

    public String getName() {
        return this.name.getValue();
    }

    public String getDescription() {
        return this.description.getValue();
    }

    public CalendarPicker getDateStarted() {
        return this.dateStarted;
    }

    public CalendarPicker getDateRelease() {
        return this.dateRelease;
    }

    public Map<String, String> getFormErrors() {
        return FormUtils.getAuiFormErrors((PageElement)this.form);
    }

    public Collection<String> getGlobalErrors() {
        return FormUtils.getAuiFormGlobalErrors((PageElement)this.form);
    }

    public VersionEditPage typeName(String text) {
        this.name.clear();
        this.name.type(new CharSequence[]{text});
        return this;
    }

    public VersionEditPage typeDescription(String text) {
        this.description.clear();
        this.description.type(new CharSequence[]{text});
        return this;
    }

    public VersionEditPage typeDateStarted(String dateValue) {
        this.getDateStarted().setDate(dateValue);
        return this;
    }

    public VersionEditPage typeDateReleased(String dateValue) {
        this.getDateRelease().setDate(dateValue);
        return this;
    }

    public TimedCondition hasSuccessMessage() {
        return this.divSuccessMessage.timed().isPresent();
    }

    public TimedCondition hasGlobalError() {
        return this.divGlobalError.timed().isPresent();
    }
}

