/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.legacy;

import com.atlassian.jira.projects.pageobjects.webdriver.page.legacy.browseversion.BrowseVersionPage;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class VersionRow {
    private final String projectKey;
    private final PageElement rowElement;
    private final PageElement nameCell;
    private final PageElement link;
    @Inject
    private PageBinder pageBinder;

    public VersionRow(String projectKey, PageElement rowElem) {
        this.projectKey = (String)Assertions.notNull((Object)projectKey);
        this.rowElement = (PageElement)Assertions.notNull((Object)rowElem);
        this.nameCell = rowElem.find(By.cssSelector((String)"[data-cell-type='name']"));
        this.link = this.nameCell.find(By.tagName((String)"a"));
    }

    public String getId() {
        String htmlId = this.link.getAttribute("id");
        return htmlId.replace("version_", "");
    }

    public String getName() {
        return this.rowElement.getAttribute("data-version-name");
    }

    public BrowseVersionPage goToBrowseVersion() {
        String id = this.getId();
        this.link.click();
        return (BrowseVersionPage)((Object)this.pageBinder.bind(BrowseVersionPage.class, new Object[]{this.projectKey, id}));
    }
}

