/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.pageobjects.components.CalendarPicker;
import com.atlassian.jira.pageobjects.components.DropDown;
import com.atlassian.jira.pageobjects.dialogs.JiraDialog;
import com.atlassian.jira.pageobjects.framework.util.TimedQueryFactory;
import com.atlassian.jira.pageobjects.navigator.AdvancedSearch;
import com.atlassian.jira.pageobjects.project.versions.MergeDialog;
import com.atlassian.jira.pageobjects.util.TraceContext;
import com.atlassian.jira.pageobjects.util.Tracer;
import com.atlassian.jira.projects.pageobjects.webdriver.page.RetryControls;
import com.atlassian.jira.projects.pageobjects.webdriver.page.releases.VersionEditPage;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.SidebarBrowseProjectSubPage;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.webtest.webdriver.util.AUIBlanket;
import com.atlassian.jira.webtest.webdriver.util.AUIFlags;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.ProductInstance;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverElement;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.query.webdriver.GenericWebDriverTimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.ButtonReleaseAction;
import org.openqa.selenium.interactions.ClickAndHoldAction;
import org.openqa.selenium.interactions.CompositeAction;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.MoveToOffsetAction;
import org.openqa.selenium.interactions.SendKeysAction;
import org.openqa.selenium.internal.Locatable;

public abstract class AbstractReleasePage<T extends AbstractReleasePage>
extends SidebarBrowseProjectSubPage {
    public static final String RELEASE_PAGE_KEY = "com.atlassian.jira.jira-projects-plugin:release-page";
    public static String STATUS_NO_FILTER = "no-filter";
    public static String STATUS_UNRELEASED = "unreleased";
    public static String STATUS_RELEASED = "released";
    public static String STATUS_ARCHIVED = "archived";
    public static String STATUS_ALL = "all";
    protected final String projectKey;
    protected final String status;
    protected final String contains;
    private final String STATUS_BUTTON_CHECKED_CLASS = "version-filter-status-pressed";
    private final String STATUS_CHANGED_CHECKPOINT = "project.release.status.changed";
    @ElementBy(cssSelector="#release-page[data-ready=true]")
    private PageElement releasePageContainer;
    @ElementBy(id="versions-table")
    private PageElement versionsTable;
    @ElementBy(id="filter-container")
    private PageElement filterContainer;
    @ElementBy(id="version-filter")
    private PageElement filterForm;
    @ElementBy(cssSelector=".version-filter-status-container .version-filter-status-released")
    private PageElement releasedButton;
    @ElementBy(cssSelector=".version-filter-status-container .version-filter-status-unreleased")
    private PageElement unreleasedButton;
    @ElementBy(cssSelector=".version-filter-status-container .version-filter-status-archived")
    private PageElement archivedButton;
    @ElementBy(id="manage-versions")
    private PageElement manageVersions;
    @ElementBy(id="versions-merge")
    private PageElement mergeLink;
    @ElementBy(cssSelector=".versions-table__row-empty img.releases-logo")
    private PageElement emptySearchImage;
    @ElementBy(cssSelector=".no-versions img.releases-logo")
    private PageElement noVersionsImage;
    @Inject
    private TimedQueryFactory timedQueryFactory;
    @Inject
    private PageBinder pageBinder;
    @Inject
    private TraceContext traceContext;
    @Inject
    private ProductInstance jiraProduct;
    @Inject
    AUIFlags flags;
    private boolean obsolete = false;
    public static final String VERSION_BY_NAME_XPATH = "//tbody[contains(@class, \"items\")]//div[text()=\"%s\" or a/text()=\"%s\"]/../..";

    public AbstractReleasePage(String projectKey) {
        this(projectKey, null, null);
    }

    public AbstractReleasePage(String projectKey, String status) {
        this(projectKey, status, null);
    }

    public AbstractReleasePage(String projectKey, String status, String contains) {
        super(projectKey);
        this.projectKey = projectKey;
        this.status = status;
        this.contains = contains;
    }

    @Override
    public String getUrl() {
        StringBuilder hash = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.status)) {
            hash.append("&status=" + this.status);
        }
        if (StringUtils.isNotBlank((String)this.contains)) {
            hash.append("&contains=" + this.contains);
        }
        return super.getUrl() + hash.toString();
    }

    public AbstractReleasePage ready() {
        try {
            URI expectedUri = new URI(this.jiraProduct.getBaseUrl() + this.getUrl());
            Poller.waitUntilTrue((String)"Failed to bind because URL is different then the expected one.", (TimedQuery)Conditions.forSupplier((long)this.timeouts.timeoutFor(TimeoutType.PAGE_LOAD), () -> this.getCurrentUri().equals(expectedUri)));
            this.flags.closeAllFlags();
            return this;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private URI getCurrentUri() {
        try {
            String currentUrl = this.driver.getCurrentUrl();
            return new URI(URLDecoder.decode(currentUrl, "UTF-8"));
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @WaitUntil
    public void doWait() {
        try {
            Poller.waitUntil((String)("Waiting for page load failed for " + ((Object)((Object)this)).getClass().getName()), (TimedQuery)this.isAt(), (Matcher)Matchers.is((Object)true), (Poller.WaitTimeout)Poller.by((long)2L, (TimeUnit)TimeUnit.MINUTES));
        }
        catch (UnhandledAlertException var6) {
            Alert alert = this.driver.switchTo().alert();
            String text = alert.getText();
            throw new UnhandledAlertException(var6.getLocalizedMessage(), "Alert window present with text +" + text);
        }
    }

    @Override
    public TimedCondition isAt() {
        return this.releasePageContainer.timed().isVisible();
    }

    @Override
    public String getPageId() {
        return RELEASE_PAGE_KEY;
    }

    private PageElement getVersionElementByName(String name) {
        return this.versionsTable.find(By.xpath((String)String.format(VERSION_BY_NAME_XPATH, name, name)));
    }

    public Version getVersionByName(String name) {
        this.assertNotObsolete();
        PageElement tableRow = this.getVersionElementByName(name);
        return (Version)this.pageBinder.bind(Version.class, new Object[]{tableRow, this.projectKey});
    }

    public int getVersionIndex(String name) {
        this.assertNotObsolete();
        List versionIds = (List)this.versionsTable.findAll(By.cssSelector((String)"tr[data-version-id]")).stream().map(element -> element.getAttribute("data-version-id")).collect(CollectorsUtil.toImmutableList());
        return versionIds.indexOf(this.getVersionByName(name).getId());
    }

    public TimedCondition isVersionByNamePresent(String name) {
        this.assertNotObsolete();
        PageElement tableRow = this.getVersionElementByName(name);
        return tableRow.timed().isPresent();
    }

    public Version getVersionAt(int position) {
        this.assertNotObsolete();
        String selector = "#versions-table tbody.items tr:nth-child(%d)";
        PageElement tableRow = this.versionsTable.find(By.cssSelector((String)String.format(selector, position)));
        return (Version)this.pageBinder.bind(Version.class, new Object[]{tableRow, this.projectKey});
    }

    public int getVersionCount() {
        this.assertNotObsolete();
        String selector = "tbody.items tr:not(.versions-table__row-empty)";
        return this.versionsTable.findAll(By.cssSelector((String)selector)).size();
    }

    public TimedCondition isEmpty() {
        return this.versionsTable.find(By.cssSelector((String)".no-results")).timed().isPresent();
    }

    public T filterByText(String text) {
        this.assertNotObsolete();
        this.filterContainer.find(By.id((String)"version-filter-text")).clear().type(new CharSequence[]{text});
        return this.bindPage(this.projectKey, this.status, text);
    }

    public TimedQuery<String> getFilterText() {
        return this.filterContainer.find(By.id((String)"version-filter-text")).timed().getValue();
    }

    public TimedCondition isFilterFormPresent() {
        return this.filterForm.timed().isPresent();
    }

    public T filterByStatus(String status) {
        boolean isValidStatus;
        boolean bl = isValidStatus = status.equals(STATUS_UNRELEASED) || status.equals(STATUS_RELEASED) || status.equals(STATUS_ARCHIVED) || status.equals(STATUS_ALL) || status.equals(STATUS_NO_FILTER);
        if (!isValidStatus) {
            throw new IllegalArgumentException("The status to filter by is invalid.");
        }
        this.assertNotObsolete();
        this.toggleUnreleased(status.equals(STATUS_UNRELEASED) || status.equals(STATUS_ALL));
        this.toggleReleased(status.equals(STATUS_RELEASED) || status.equals(STATUS_ALL));
        this.toggleArchived(status.equals(STATUS_ARCHIVED) || status.equals(STATUS_ALL));
        return this.bindPage(this.projectKey, status, this.contains);
    }

    public static Map<String, String> getFilterParamsFromUrl(String url) {
        HashMap params = Maps.newHashMap();
        if (url.contains("?")) {
            String[] hashParams;
            String[] split = url.split("[?]");
            if (split.length < 2) {
                return params;
            }
            for (String param : hashParams = split[1].split("&")) {
                String[] paramParts = param.split("=");
                if (paramParts.length != 2) continue;
                params.put(paramParts[0], paramParts[1]);
            }
        }
        return params;
    }

    private T bindPage(String projectKey, String status, String contains) {
        this.obsolete = true;
        return (T)((Object)((AbstractReleasePage)((Object)this.pageBinder.bind(((Object)((Object)this)).getClass(), new Object[]{projectKey, status, contains}))).ready());
    }

    private void assertNotObsolete() {
        if (this.obsolete) {
            throw new IllegalStateException("This page object produced another one. It is obsolete and the new one should be used instead.");
        }
    }

    private void toggleUnreleased(boolean isChecked) {
        boolean isSelected = this.unreleasedButton.hasClass("version-filter-status-pressed");
        Tracer checkpoint = this.traceContext.checkpoint();
        if (!isSelected && isChecked || isSelected && !isChecked) {
            this.unreleasedButton.click();
            this.traceContext.waitFor(checkpoint, "project.release.status.changed");
        }
    }

    private void toggleReleased(boolean isChecked) {
        boolean isSelected = this.releasedButton.hasClass("version-filter-status-pressed");
        Tracer checkpoint = this.traceContext.checkpoint();
        if (!isSelected && isChecked || isSelected && !isChecked) {
            this.releasedButton.click();
            this.traceContext.waitFor(checkpoint, "project.release.status.changed");
        }
    }

    private void toggleArchived(boolean isChecked) {
        boolean isSelected = this.archivedButton.hasClass("version-filter-status-pressed");
        Tracer checkpoint = this.traceContext.checkpoint();
        if (!isSelected && isChecked || isSelected && !isChecked) {
            this.archivedButton.click();
            this.traceContext.waitFor(checkpoint, "project.release.status.changed");
        }
    }

    public T revealNextPage() {
        int currentCount = this.getVersionCount();
        Tracer tracer = this.traceContext.checkpoint();
        this.scrollToBottom();
        this.traceContext.waitFor(tracer, "jira.projects.scroll.checked");
        Poller.waitUntil((TimedQuery)this.timedQueryFactory.forSupplier(this::getVersionCount), (Matcher)Is.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(currentCount))));
        return (T)((Object)this);
    }

    public void scrollToTop() {
        JavascriptExecutor jse = (JavascriptExecutor)this.driver.getDriver();
        jse.executeScript("window.scrollTo(0, 0)", new Object[0]);
    }

    public long scrollToBottom() {
        JavascriptExecutor jse = (JavascriptExecutor)this.driver.getDriver();
        jse.executeScript("window.scrollTo(0, document.body.scrollHeight);", new Object[0]);
        return this.getScrollY();
    }

    public long getScrollY() {
        JavascriptExecutor jse = (JavascriptExecutor)this.driver.getDriver();
        return (Long)jse.executeScript("return window.scrollY", new Object[0]);
    }

    public TimedCondition isManageVersionsPresent() {
        return this.manageVersions.timed().isPresent();
    }

    public TimedCondition isEmptySearchImagePresent() {
        return this.emptySearchImage.timed().isPresent();
    }

    public TimedCondition isNoVersionsImagePresent() {
        return this.noVersionsImage.timed().isPresent();
    }

    public TimedCondition isArchivedButtonPresent() {
        return this.archivedButton.timed().isPresent();
    }

    public TimedCondition isArchivedSelected() {
        return this.archivedButton.timed().hasClass("version-filter-status-pressed");
    }

    public TimedCondition isReleasedSelected() {
        return this.releasedButton.timed().hasClass("version-filter-status-pressed");
    }

    public TimedCondition isUnreleasedSelected() {
        return this.unreleasedButton.timed().hasClass("version-filter-status-pressed");
    }

    public PageElement getMergeLink() {
        return this.mergeLink;
    }

    public MergeDialog openMergeDialog() {
        this.mergeLink.click();
        return (MergeDialog)this.pageBinder.bind(MergeDialog.class, new Object[0]);
    }

    public String getServerError() {
        JiraDialog dialog = (JiraDialog)this.pageBinder.bind(JiraDialog.class, new Object[]{"server-error-dialog"});
        Poller.waitUntilTrue((TimedQuery)dialog.isOpen());
        return dialog.find(By.className((String)"aui-message")).getText();
    }

    public boolean isSortable() {
        return (Boolean)this.versionsTable.find(By.cssSelector((String)".versions-table__handle")).timed().isVisible().byDefaultTimeout();
    }

    public List<TimedQuery<String>> getVersions() {
        int versionCount = this.getVersionCount();
        ArrayList<TimedQuery<String>> resultList = new ArrayList<TimedQuery<String>>(versionCount);
        for (int i = 0; i < versionCount; ++i) {
            Version version = this.getVersionAt(i + 1);
            resultList.add(version.getName());
        }
        return resultList;
    }

    public ReleaseForm getReleaseForm() {
        return (ReleaseForm)this.pageBinder.bind(ReleaseForm.class, new Object[]{this.releasePageContainer.find(By.id((String)"releases-add__version"))});
    }

    public static enum VersionStatus {
        RELEASED,
        UNRELEASED,
        ARCHIVED;

    }

    public static class ReleaseForm {
        @Inject
        private PageBinder pageBinder;
        @Inject
        private TraceContext traceContext;
        private PageElement releaseForm;
        private CalendarPicker dateStarted;
        private CalendarPicker dateRelease;

        public ReleaseForm(PageElement releaseForm) {
            this.releaseForm = releaseForm;
        }

        @Init
        public void init() {
            this.dateStarted = (CalendarPicker)this.pageBinder.bind(CalendarPicker.class, new Object[]{By.cssSelector((String)".releases-add__date-start input"), By.cssSelector((String)".releases-add__date-start .aui-iconfont-calendar")});
            this.dateRelease = (CalendarPicker)this.pageBinder.bind(CalendarPicker.class, new Object[]{By.cssSelector((String)".releases-add__date-release input"), By.cssSelector((String)".releases-add__date-release .aui-iconfont-calendar")});
        }

        private void fillField(String name, String value) {
            this.releaseForm.find(By.cssSelector((String)String.format(".releases-add__%s input", name))).type(new CharSequence[]{value});
        }

        public void addVersion(String name, String startDate, String endDate, String description) {
            Tracer tracer = this.traceContext.checkpoint();
            this.fillField("name", name);
            this.fillField("date-start", startDate);
            this.fillField("date-release", endDate);
            this.fillField("description", description);
            PageElement button = this.releaseForm.find(By.cssSelector((String)".releases-add__confirm button"));
            Poller.waitUntilTrue((TimedQuery)button.timed().isEnabled());
            button.click();
            this.traceContext.waitFor(tracer, "jira.version.add.finished");
        }

        public TimedCondition isPresent() {
            return this.releaseForm.timed().isPresent();
        }

        public CalendarPicker getDateStartPicker() {
            return this.dateStarted;
        }

        public CalendarPicker getDateReleasePicker() {
            return this.dateRelease;
        }
    }

    public static class DeleteOperation
    extends com.atlassian.jira.pageobjects.project.versions.operations.DeleteOperation {
        @Inject
        private PageElementFinder finder;
        @Inject
        AUIBlanket blanket;

        public DeleteOperation(String versionId) {
            super(versionId);
        }

        public <X extends AbstractReleasePage> X submitReleasePage(Class<X> cls) {
            this.submitButton.click();
            Poller.waitUntilTrue((TimedQuery)this.isClosed());
            String projectKey = this.finder.find(By.name((String)"projectKey")).getAttribute("content");
            this.blanket.waitUntilClosed();
            return (X)((Object)((AbstractReleasePage)((Object)this.binder.bind(cls, new Object[]{projectKey}))));
        }

        public int getSwapAffectVersionSelectSize() {
            return this.swapAffectVersionSelect.findAll(By.tagName((String)"option")).size();
        }

        public int getSwapFixVersionSelect() {
            return this.swapFixVersionSelect.findAll(By.tagName((String)"option")).size();
        }
    }

    public static class ProgressBarDialog {
        private PageElement statusesTable;
        @Inject
        private AtlassianWebDriver driver;
        @Inject
        private PageBinder pageBinder;

        public ProgressBarDialog(PageElement statusTable) {
            this.statusesTable = statusTable;
        }

        public TimedQuery<String> getIssuesTodoLink() {
            return this.getTodoLinkElement().timed().getAttribute("href");
        }

        private PageElement getTodoLinkElement() {
            return this.statusesTable.find(By.cssSelector((String)"a:first-child"));
        }

        public AdvancedSearch navigateTodoLink() {
            PageElement todoLink = this.getTodoLinkElement();
            String href = todoLink.getAttribute("href");
            this.driver.navigate().to(href);
            return (AdvancedSearch)this.pageBinder.bind(AdvancedSearch.class, new Object[0]);
        }
    }

    public static class Progressbar {
        @Inject
        private PageBinder pageBinder;
        @Inject
        private AtlassianWebDriver driver;
        @Inject
        private PageElementFinder elementFinder;
        private PageElement parent;
        private PageElement progressbarContainer;
        private PageElement progressbarEntryComplete;
        private PageElement progressbarEntryInProgress;
        private PageElement progressbarEntryTodo;
        private PageElement progressbarEntryUndefined;

        public Progressbar(PageElement parent) {
            this.parent = parent;
        }

        @Init
        public void initElements() {
            this.progressbarContainer = this.parent.find(By.cssSelector((String)".progressbar-container"));
            this.progressbarEntryComplete = this.progressbarContainer.find(By.cssSelector((String)".complete"));
            this.progressbarEntryInProgress = this.progressbarContainer.find(By.cssSelector((String)".in-progress"));
            this.progressbarEntryTodo = this.progressbarContainer.find(By.cssSelector((String)".to-do"));
            this.progressbarEntryUndefined = this.progressbarContainer.find(By.cssSelector((String)".undefined"));
        }

        public TimedCondition isProgressBarPresent() {
            return this.progressbarContainer.timed().isPresent();
        }

        public ProgressBarDialog showProgressBarDialog() {
            Actions action = new Actions((WebDriver)this.driver);
            WebElement progressBarFull = this.driver.findElement(By.cssSelector((String)".progressbar_full"));
            action.moveToElement(progressBarFull).perform();
            PageElement statusesTable = this.elementFinder.find(By.cssSelector((String)".progress-statuses__table"));
            Poller.waitUntilTrue((TimedQuery)new GenericWebDriverTimedQuery(() -> ((PageElement)statusesTable).isPresent(), 100L));
            return (ProgressBarDialog)this.pageBinder.bind(ProgressBarDialog.class, new Object[]{statusesTable});
        }
    }

    public static class Version {
        public static final String DELETE_CLASSNAME = "project-config-operations-delete";
        public static final String ARCHIVE_CLASSNAME = "project-config-operations-archive";
        public static final String EDIT_CLASSNAME = "version-edit-dialog";
        public static final String UNARCHIVE_CLASSNAME = "project-config-operations-unarchive";
        @Inject
        private PageBinder pageBinder;
        @Inject
        TimedQueryFactory timedQueryFactory;
        @Inject
        private AtlassianWebDriver driver;
        @Inject
        private PageElementFinder elementFinder;
        @Inject
        private TraceContext traceContext;
        private final PageElement rowElement;
        private final String projectKey;
        private PageElement name;
        private PageElement status;
        private PageElement description;
        private PageElement dateStart;
        private PageElement dateRelease;
        private PageElement retryContainer;
        private PageElement actionsTrigger;
        private PageElement progress;
        private ActionsDropDown dropDown;

        public Version(PageElement rowElement, String projectKey) {
            this.rowElement = rowElement;
            this.projectKey = projectKey;
        }

        @Init
        public void initContent() {
            this.name = this.rowElement.find(By.cssSelector((String)".versions-table__name a"));
            this.status = this.rowElement.find(By.cssSelector((String)".versions-table__status span"));
            this.description = this.rowElement.find(By.cssSelector((String)".versions-table__description"));
            this.dateStart = this.rowElement.find(By.cssSelector((String)".versions-table__date_start"));
            this.dateRelease = this.rowElement.find(By.cssSelector((String)".versions-table__date_release"));
            this.retryContainer = this.rowElement.find(By.cssSelector((String)".operation-retry"));
            this.progress = this.rowElement.find(By.cssSelector((String)".versions-table__progress"));
        }

        private WebElement getDragHandle() {
            return this.rowElement.hasClass("item-state-ready") ? ((WebDriverElement)this.rowElement.find(By.cssSelector((String)".versions-table__handle .aui-icon"))).asWebElement() : null;
        }

        public <T> T clickName(Class<T> pageClass, Object ... args) {
            this.name.click();
            return (T)this.pageBinder.bind(pageClass, args);
        }

        public TimedQuery<String> getName() {
            return this.name.timed().getText();
        }

        public TimedQuery<VersionStatus> getStatus() {
            return this.timedQueryFactory.forSupplier(() -> VersionStatus.valueOf(this.status.getText()));
        }

        public TimedQuery<String> getStatusText() {
            return this.timedQueryFactory.forSupplier(() -> StringUtils.upperCase((String)this.status.getText()));
        }

        public TimedQuery<String> getDateStart() {
            return this.dateStart.timed().getText();
        }

        public TimedQuery<String> getDateRelease() {
            return this.dateRelease.timed().getText();
        }

        public TimedQuery<String> getDescription() {
            return this.description.timed().getText();
        }

        public String getId() {
            return this.rowElement.getAttribute("data-version-id");
        }

        public RetryControls getRetryControls() {
            Poller.waitUntilTrue((TimedQuery)this.retryContainer.timed().isPresent());
            return (RetryControls)this.pageBinder.bind(RetryControls.class, new Object[]{this.retryContainer});
        }

        public TimedQuery<Boolean> hasErrorClass() {
            return this.timedQueryFactory.forSupplier(() -> this.rowElement.hasClass("item-state-error-add") || this.rowElement.hasClass("item-state-error-delete") || this.rowElement.hasClass("item-state-error-update"));
        }

        public TimedCondition hasSuccessClass() {
            return this.rowElement.timed().hasClass("item-state-successful");
        }

        public TimedCondition isDraggable() {
            return this.rowElement.timed().hasClass("item-state-ready");
        }

        public ActionsDropDown getDropDown() {
            if (this.dropDown == null) {
                this.dropDown = (ActionsDropDown)((Object)this.pageBinder.bind(ActionsDropDown.class, new Object[]{this.getActionsTrigger(), By.id((String)((String)this.getActionsTrigger().timed().getAttribute("aria-controls").byDefaultTimeout()))}));
            }
            return this.dropDown;
        }

        private PageElement getActionsTrigger() {
            if (this.actionsTrigger == null) {
                this.actionsTrigger = this.rowElement.find(By.cssSelector((String)".dynamic-table__actions .aui-dropdown2-trigger"));
            }
            return this.actionsTrigger;
        }

        public void archive() {
            this.getDropDown().openAndClick(By.className((String)ARCHIVE_CLASSNAME));
        }

        public DeleteOperation delete() {
            this.getDropDown().openAndClick(By.className((String)DELETE_CLASSNAME));
            return (DeleteOperation)((Object)this.pageBinder.bind(DeleteOperation.class, new Object[]{this.getId()}));
        }

        public <T> T delete(Class<T> clazz) {
            this.getDropDown().openAndClick(By.className((String)DELETE_CLASSNAME));
            return (T)this.pageBinder.bind(clazz, new Object[]{this.getId()});
        }

        public VersionEditPage edit() {
            long versionId = Long.parseLong(this.getId());
            this.getDropDown().open().openAndClick(By.className((String)EDIT_CLASSNAME));
            return (VersionEditPage)((Object)this.pageBinder.bind(VersionEditPage.class, new Object[]{versionId, this.projectKey}));
        }

        public void unarchive() {
            this.getDropDown().open().openAndClick(By.className((String)UNARCHIVE_CLASSNAME));
        }

        public void release() {
            this.getDropDown().openAndClick(By.linkText((String)"Release"));
        }

        public void moveTo(Version targetVersion) {
            this.moveTo(targetVersion, Optional.empty());
        }

        public TimedCondition isVisible() {
            return this.rowElement.timed().isVisible();
        }

        public void moveTo(Version targetVersion, Optional<Boolean> expectedSuccess) {
            this.moveTo(targetVersion, expectedSuccess, VersionOrder.NATURAL);
        }

        public void moveToAndRollback(Version targetVersion) {
            this.prepareAndCallAction(targetVersion, VersionOrder.NATURAL, (Consumer<CompositeAction>)((Consumer)compositeAction -> compositeAction.addAction((Action)new SendKeysAction(this.driver.getKeyboard(), this.driver.getMouse(), new CharSequence[]{Keys.ESCAPE}))));
        }

        public void moveTo(Version targetVersion, Optional<Boolean> expectedSuccess, VersionOrder order) {
            Tracer tracer = this.traceContext.checkpoint();
            this.prepareAndCallAction(targetVersion, order, (Consumer<CompositeAction>)((Consumer)action -> {}));
            if (expectedSuccess.isPresent()) {
                this.traceContext.waitFor(tracer, String.format("jira.version.reorder.%s", expectedSuccess.get() != false ? "success" : "failure"));
            }
            this.traceContext.waitFor(tracer, "jira.version.reorder.finished");
        }

        private void prepareAndCallAction(Version targetVersion, VersionOrder order, Consumer<CompositeAction> beforeReleaseAction) {
            WebElement target = targetVersion.asElement();
            boolean isBelow = target.getLocation().getY() < this.getDragHandle().getLocation().getY();
            ((Locatable)this.getDragHandle()).getCoordinates().inViewPort();
            Mouse mouse = this.driver.getMouse();
            CompositeAction action = new CompositeAction();
            action.addAction((Action)new ClickAndHoldAction(mouse, (Locatable)this.getDragHandle()));
            action.addAction((Action)new MoveToOffsetAction(mouse, (Locatable)target, 1, isBelow ? -order.offsetY : order.offsetY));
            beforeReleaseAction.consume((Object)action);
            action.addAction((Action)new ButtonReleaseAction(mouse, null));
            action.perform();
        }

        private WebElement asElement() {
            return ((WebDriverElement)this.rowElement).asWebElement();
        }

        public Progressbar getProgressbar() {
            return (Progressbar)this.pageBinder.bind(Progressbar.class, new Object[]{this.progress});
        }

        public static enum VersionOrder {
            NATURAL(-15),
            BEFORE(-15),
            AFTER(25);

            public int offsetY;

            private VersionOrder(int offsetY) {
                this.offsetY = offsetY;
            }
        }
    }

    public static class ActionsDropDown
    extends DropDown {
        private PageElement actionsTrigger;

        public ActionsDropDown(PageElement actionsTrigger, By dropdownLocator) {
            super(null, dropdownLocator);
            this.actionsTrigger = actionsTrigger;
        }

        protected PageElement trigger() {
            return this.actionsTrigger;
        }

        public boolean isVisible() {
            return this.actionsTrigger.isVisible();
        }

        public ActionsDropDown open() {
            super.open();
            return this;
        }

        public TimedQuery<Boolean> hasOperation(String operation) {
            PageElement menuItem = this.dropDown().find(By.linkText((String)operation));
            return Conditions.and((TimedQuery[])new TimedQuery[]{menuItem.timed().isVisible()});
        }

        public TimedQuery<Boolean> hasOperations(List<String> visibleOperations, List<String> notVisibleOperations) {
            return Conditions.and((Iterable)ImmutableList.of((Object)Conditions.and((Iterable)visibleOperations.stream().map(this::hasOperation).collect(Collectors.toList())), (Object)Conditions.not((TimedQuery)Conditions.or((Iterable)notVisibleOperations.stream().map(this::hasOperation).collect(Collectors.toList())))));
        }
    }
}

