/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.func.page;

import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.page.AbstractWebTestPage;
import com.atlassian.jira.projects.pageobjects.func.support.SidebarHeader;
import com.atlassian.jira.projects.pageobjects.func.support.SidebarLink;
import com.atlassian.jira.projects.pageobjects.func.support.TestUtilities;
import com.google.common.collect.Lists;
import java.util.Iterator;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public abstract class ProjectCentricNavPage<T>
extends AbstractWebTestPage {
    private final String projectKey;
    private final String tabName;
    private final FuncTestHelperFactory funcTestHelperFactory;

    public ProjectCentricNavPage(String projectKey, String tabName, FuncTestHelperFactory funcTestHelperFactory) {
        this.projectKey = projectKey;
        this.tabName = tabName;
        this.funcTestHelperFactory = funcTestHelperFactory;
    }

    public String baseUrl() {
        return String.format("/projects/%s?selectedItem=%s", this.projectKey, this.tabName);
    }

    public T getPanel() {
        return this.getPanel(TestUtilities.selectOnly((Element)this.getPage(), "#sidebar-page-container"));
    }

    protected abstract T getPanel(Element var1);

    public SidebarLink getLinkByTitle(String title) {
        String linkSelector = ".aui-sidebar .aui-nav a:contains(" + title + ")";
        Element link = TestUtilities.selectOnly((Element)this.getPage(), linkSelector);
        Elements linkChildren = this.getPage().select(linkSelector + " ~ ul.aui-nav a");
        return new SidebarLink(link, Lists.newArrayList((Iterator)linkChildren.listIterator()));
    }

    public boolean hasLinkWithTitle(String title) {
        return this.getPage().select(".aui-sidebar .aui-nav a:containsOwn(" + title + ")").size() > 0;
    }

    public SidebarHeader getSidebarHeader() {
        return new SidebarHeader(TestUtilities.selectOnly((Element)this.getPage(), ".aui-sidebar .aui-page-header"));
    }

    protected Document getPage() {
        return Jsoup.parse((String)this.funcTestHelperFactory.getLocator().page().getHTML());
    }
}

