/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.shortcuts;

import com.atlassian.jira.pageobjects.util.TraceContext;
import com.atlassian.jira.pageobjects.util.Tracer;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.inject.Inject;

public abstract class ShortcutDialog {
    private final String operationName;
    @Inject
    protected TraceContext traceContext;
    @ElementBy(cssSelector=".project-shortcuts-name input", within="rootElement")
    protected PageElement name;
    @ElementBy(cssSelector=".project-shortcuts-name .error", within="rootElement")
    protected PageElement nameErrors;
    @ElementBy(cssSelector=".project-shortcuts-url input", within="rootElement")
    protected PageElement url;
    @ElementBy(cssSelector=".project-shortcuts-url .error", within="rootElement")
    protected PageElement urlErrors;
    @ElementBy(className="project-shortcuts-submit", within="rootElement")
    protected PageElement submit;
    @ElementBy(className="project-shortcuts-cancel", within="rootElement")
    protected PageElement cancel;

    protected ShortcutDialog(String operationName) {
        this.operationName = operationName;
    }

    public ShortcutDialog name(String name) {
        this.name.clear().type(new CharSequence[]{name});
        return this;
    }

    public ShortcutDialog url(String url) {
        this.url.clear().type(new CharSequence[]{url});
        return this;
    }

    public ShortcutDialog clearName() {
        this.name.clear();
        return this;
    }

    public ShortcutDialog clearUrl() {
        this.url.clear();
        return this;
    }

    public ShortcutDialog submit() {
        Tracer checkpoint = this.traceContext.checkpoint();
        this.submit.click();
        Poller.waitUntilFalse((TimedQuery)this.name.timed().isVisible());
        this.traceContext.waitFor(checkpoint, "jira.projects.shortcuts." + this.operationName + ".success");
        return this;
    }

    public ShortcutDialog submitExpectingErrors() {
        Tracer checkpoint = this.traceContext.checkpoint();
        this.submit.click();
        this.traceContext.waitFor(checkpoint, "jira.projects.shortcuts." + this.operationName + ".fail");
        return this;
    }

    @WaitUntil
    public TimedCondition isAt() {
        return this.name.timed().isVisible();
    }

    public TimedQuery<String> getNameError() {
        return this.nameErrors.timed().getText();
    }

    public TimedQuery<String> getUrlError() {
        return this.urlErrors.timed().getText();
    }
}

