/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar;

import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.CollapsedScopeFilter;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.ScopeFilter;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.shortcuts.SidebarProjectShortcutsSection;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.google.inject.Inject;
import org.apache.commons.lang.NotImplementedException;
import org.openqa.selenium.By;

public class Sidebar {
    @Inject
    private PageBinder pageBinder;
    @Inject
    private PageElementFinder elementFinder;
    @ElementBy(className="aui-sidebar")
    private PageElement sidebar;
    @ElementBy(cssSelector="a.aui-sidebar-toggle")
    private PageElement sidebarToggle;
    private final String projectKey;

    public Sidebar(String projectKey) {
        this.projectKey = projectKey;
    }

    public TimedCondition isPresent() {
        return this.sidebar.timed().isVisible();
    }

    public Sidebar expandSidebar() {
        if (((Boolean)this.sidebarIsCollapsed().now()).booleanValue()) {
            this.toggleSidebar();
        }
        Poller.waitUntilFalse((TimedQuery)this.sidebarIsCollapsed());
        return this;
    }

    public ScopeFilter getScopeFilter() {
        if (!((Boolean)this.sidebarIsCollapsed().now()).booleanValue()) {
            throw new NotImplementedException("We have not yet implemented a page object to represent ScopeFilter in an expanded state.");
        }
        ScopeFilter scopeFilter = (ScopeFilter)this.pageBinder.bind(CollapsedScopeFilter.class, new Object[0]);
        return scopeFilter;
    }

    public Sidebar collapseSidebar() {
        if (!((Boolean)this.sidebarIsCollapsed().now()).booleanValue()) {
            this.toggleSidebar();
        }
        Poller.waitUntilTrue((TimedQuery)this.sidebarIsCollapsed());
        return this;
    }

    public TimedCondition sidebarIsCollapsed() {
        return this.sidebar.timed().hasAttribute("aria-expanded", "false");
    }

    private void toggleSidebar() {
        this.sidebarToggle.click();
    }

    public SidebarProjectShortcutsSection getShortcutsSection() {
        PageElement rootElement = (Boolean)this.sidebarIsCollapsed().now() != false ? this.elementFinder.find(By.id((String)"inline-dialog-sidebar-submenu")) : this.sidebar.find(By.className((String)"project-shortcuts-group"));
        return (SidebarProjectShortcutsSection)this.pageBinder.bind(SidebarProjectShortcutsSection.class, new Object[]{rootElement});
    }

    public SidebarLink getLinkByName(String name) {
        PageElement pageElement = this.getLinkElementByName(name);
        if (!pageElement.isPresent()) {
            pageElement = this.getLinkElementByName(this.getRenamedLinkName(name));
        }
        return (SidebarLink)this.pageBinder.bind(SidebarLink.class, new Object[]{pageElement});
    }

    public SidebarLink getLinkById(String id) {
        PageElement pageElement = this.getLinkElementById(id);
        return (SidebarLink)this.pageBinder.bind(SidebarLink.class, new Object[]{pageElement});
    }

    private PageElement getLinkElementByName(String name) {
        String xpath = "//span[text()=\"%s\" and @class=\"%s\"]/../..";
        return this.sidebar.find(By.xpath((String)String.format(xpath, name, "aui-nav-item-label")), TimeoutType.SLOW_PAGE_LOAD);
    }

    private PageElement getLinkElementById(String id) {
        String xpath = "//*[contains(@class, \"aui-sidebar\")]//a[@data-link-id=\"%s\"]/..";
        return this.sidebar.find(By.xpath((String)String.format(xpath, id)), TimeoutType.SLOW_PAGE_LOAD);
    }

    private String getRenamedLinkName(String requestedName) {
        if ("Report".equals(requestedName)) {
            return "Reports";
        }
        if ("Reports".equals(requestedName)) {
            return "Report";
        }
        if ("Release".equals(requestedName)) {
            return "Releases";
        }
        if ("Releases".equals(requestedName)) {
            return "Release";
        }
        return requestedName;
    }

    public static class SidebarLink {
        @Inject
        private PageBinder pageBinder;
        private final PageElement parentElement;
        private final PageElement linkElement;

        public SidebarLink(PageElement parentElement) {
            this.parentElement = parentElement;
            this.linkElement = parentElement.find(By.className((String)"aui-nav-item"));
        }

        public TimedCondition isVisible() {
            return this.linkElement.timed().isVisible();
        }

        public TimedCondition isSelected() {
            return this.parentElement.timed().hasClass("aui-nav-selected");
        }

        public TimedQuery<String> getUrl() {
            return this.linkElement.timed().getAttribute("href");
        }

        public <T> T click(Class<T> pageClass, Object ... args) {
            Poller.waitUntilTrue((TimedQuery)this.linkElement.timed().isPresent());
            this.linkElement.click();
            return (T)this.pageBinder.bind(pageClass, args);
        }

        public void toggleTwixi() {
            this.parentElement.find(By.className((String)"aui-nav-subtree-toggle")).click();
        }
    }
}

