/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar;

import com.atlassian.jira.pageobjects.JiraTestedProduct;
import com.atlassian.jira.pageobjects.util.TraceContext;
import com.atlassian.jira.pageobjects.util.Tracer;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.common.base.Preconditions;
import javax.inject.Inject;

public class ProjectCentricNavigationUserOptions {
    private static final String ENABLE_OPTION_CSS_CLASS = "enable-project-centric-nav";
    private static final String DISABLE_OPTION_CSS_CLASS = "disable-project-centric-nav";
    @Inject
    private JiraTestedProduct jira;
    @Inject
    private TraceContext traceContext;
    @ElementBy(cssSelector="#user-options .aui-dropdown2-trigger")
    private PageElement userOptionsTrigger;
    @ElementBy(cssSelector=".project-centric-nav-user-option")
    private PageElement userOption;

    @WaitUntil
    public void userOptionsTriggerIsVisible() {
        Poller.waitUntilTrue((TimedQuery)this.userOptionsTrigger.timed().isVisible());
    }

    public boolean hasOptionToEnableProjectCentricNavigation() {
        return this.userOption.isPresent() && this.userOption.hasClass(ENABLE_OPTION_CSS_CLASS);
    }

    public void enableProjectCentricNavigation() {
        Preconditions.checkState((boolean)this.hasOptionToEnableProjectCentricNavigation());
        this.clickOption();
        Poller.waitUntilFalse((TimedQuery)this.userOption.timed().hasClass(ENABLE_OPTION_CSS_CLASS));
    }

    public boolean hasOptionToDisableProjectCentricNavigation() {
        return this.userOption.isPresent() && this.userOption.hasClass(DISABLE_OPTION_CSS_CLASS);
    }

    public void disableProjectCentricNavigation() {
        Preconditions.checkState((boolean)this.hasOptionToDisableProjectCentricNavigation());
        Tracer tracer = this.traceContext.checkpoint();
        this.clickOption();
        Poller.waitUntilTrue((TimedQuery)this.traceContext.condition(tracer, "sidebar.darkfeature.toggled"));
        this.jira.getTester().getDriver().navigate().refresh();
        Poller.waitUntilFalse((TimedQuery)this.userOption.timed().hasClass(DISABLE_OPTION_CSS_CLASS));
    }

    private void clickOption() {
        this.userOptionsTrigger.click();
        Poller.waitUntilTrue((TimedQuery)this.userOption.timed().isVisible());
        this.userOption.click();
    }
}

