/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar;

import com.atlassian.fugue.Option;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.ScopeFilter;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.ScopeFilterItem;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Actions;

public class CollapsedScopeFilter
implements ScopeFilter {
    @Inject
    private WebDriver driver;
    @Inject
    private PageElementFinder elementFinder;
    @Inject
    private PageBinder pageBinder;
    @ElementBy(className="collapsed-scope-filter-container")
    private PageElement trigger;
    @ElementBy(className="collapsed-scope-list")
    private PageElement scopeList;

    @WaitUntil
    public void triggerIsVisible() {
        Poller.waitUntilTrue((TimedQuery)this.trigger.timed().isVisible());
    }

    @Override
    public Option<String> getSelectedScopeLabel() {
        List allMatches = this.scopeList.findAll(By.className((String)"selected-scope-filter"));
        return allMatches.isEmpty() ? Option.none() : Option.some((Object)((PageElement)Iterables.getOnlyElement((Iterable)allMatches)).getAttribute("title"));
    }

    @Override
    public List<ScopeFilterItem> getSelectableItems() {
        List allMatches = this.scopeList.findAll(By.tagName((String)"a"));
        return Lists.transform((List)allMatches, (Function)PageElementToScopeFilterItem.toScopeFilterItem());
    }

    @Override
    public <T> T selectItemByLabel(String label, Class<T> nextPage, Object ... pageArgs) {
        Actions actions = new Actions(this.driver);
        actions.moveToElement(((WebDriverElement)this.trigger).asWebElement()).moveToElement(((WebDriverElement)this.elementFinder.find(By.linkText((String)label))).asWebElement()).click().build().perform();
        return (T)this.pageBinder.bind(nextPage, pageArgs);
    }

    static final class PageElementToScopeFilterItem
    implements Function<PageElement, ScopeFilterItem> {
        private static final PageElementToScopeFilterItem INSTANCE = new PageElementToScopeFilterItem();

        private PageElementToScopeFilterItem() {
        }

        static PageElementToScopeFilterItem toScopeFilterItem() {
            return INSTANCE;
        }

        public ScopeFilterItem apply(PageElement pageElement) {
            return new ScopeFilterItem(pageElement.getAttribute("title"), pageElement.getAttribute("href"));
        }
    }
}

