/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar;

import com.atlassian.fugue.Option;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.AbstractTimedQuery;
import com.atlassian.pageobjects.elements.query.ExpirationHandler;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class Chaperone {
    @Inject
    private PageElementFinder pageElementFinder;
    @Inject
    protected Timeouts timeouts;
    private PageElement visibleDialog;
    private int expectedStartingSequence;

    public Chaperone(int expectedStartingSequence) {
        this.expectedStartingSequence = expectedStartingSequence;
    }

    @WaitUntil
    public void firstDialogIsVisible() {
        this.expectDialogWithSequenceNumber(this.expectedStartingSequence);
    }

    public boolean hasNext() {
        return this.getSequenceNumber() < this.getTotalNumberOfSteps();
    }

    public boolean hasCloseButton() {
        return !this.visibleDialog.findAll(By.className((String)"helptip-close")).isEmpty();
    }

    public void next() {
        int nextSequenceNumber = this.getSequenceNumber() + 1;
        PageElement nextButton = this.visibleDialog.find(By.className((String)"helptip-next"));
        nextButton.click();
        this.expectDialogWithSequenceNumber(nextSequenceNumber);
    }

    public int getSequenceNumber() {
        return (Integer)this.getSequenceComponent(this.visibleDialog, SequenceComponentType.SEQUENCE_NUMBER).get();
    }

    public int getTotalNumberOfSteps() {
        return (Integer)this.getSequenceComponent(this.visibleDialog, SequenceComponentType.SEQUENCE_COUNT).get();
    }

    private void expectDialogWithSequenceNumber(int sequenceNumber) {
        DialogWithSequenceNumberIsVisible dialogQuery = new DialogWithSequenceNumberIsVisible(sequenceNumber);
        PageElement dialogElement = (PageElement)dialogQuery.byDefaultTimeout();
        Preconditions.checkState((dialogElement != null ? 1 : 0) != 0);
        this.visibleDialog = dialogElement;
    }

    private Option<Integer> getSequenceComponent(PageElement dialog, SequenceComponentType sequenceComponentType) {
        PageElement elem = dialog.find(By.className((String)"helptip-sequence-paging"));
        String[] sequenceComponents = elem.getText().trim().split("/");
        String sequenceComponent = sequenceComponentType == SequenceComponentType.SEQUENCE_NUMBER ? sequenceComponents[0] : sequenceComponents[1];
        return Strings.isNullOrEmpty((String)sequenceComponent) ? Option.none() : Option.some((Object)Integer.parseInt(sequenceComponent));
    }

    private final class DialogWithSequenceNumberIsVisible
    extends AbstractTimedQuery<PageElement> {
        private final int expectedSequenceNumber;

        private DialogWithSequenceNumberIsVisible(int expectedSequenceNumber) {
            super(Chaperone.this.timeouts.timeoutFor(TimeoutType.DEFAULT), 100L, ExpirationHandler.RETURN_CURRENT);
            this.expectedSequenceNumber = expectedSequenceNumber;
        }

        protected boolean shouldReturn(PageElement currentEval) {
            return currentEval != null;
        }

        protected PageElement currentValue() {
            List foundElements = Chaperone.this.pageElementFinder.findAll(By.className((String)"jira-help-tip"));
            for (PageElement foundElement : foundElements) {
                Option option;
                if (!foundElement.isVisible() || !(option = Chaperone.this.getSequenceComponent(foundElement, SequenceComponentType.SEQUENCE_NUMBER)).isDefined() || !((Integer)option.get()).equals(this.expectedSequenceNumber)) continue;
                return foundElement;
            }
            return null;
        }
    }

    private static enum SequenceComponentType {
        SEQUENCE_NUMBER,
        SEQUENCE_COUNT;

    }
}

