/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.legacy;

import com.atlassian.jira.projects.pageobjects.webdriver.page.legacy.BrowseProjectPage;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.SidebarBrowseProjectPage;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import javax.inject.Inject;

public class SidebarEnablerDialog {
    private final String projectKey;
    @Inject
    private PageBinder pageBinder;
    @ElementBy(className="jira-projects-enabler-dialog")
    private PageElement dialog;
    @ElementBy(cssSelector="button.try-project-centric-nav")
    private PageElement okButton;
    @ElementBy(cssSelector=".jira-projects-enabler-dialog button.close")
    private PageElement cancelButton;

    public SidebarEnablerDialog(String projectKey) {
        this.projectKey = projectKey;
    }

    @WaitUntil
    public void dialogFinishesDisplayAnimation() {
        TimedCondition displayAnimationIsFinished = this.dialog.timed().hasAttribute("style", "top: 0px;");
        Poller.waitUntilTrue((TimedQuery)displayAnimationIsFinished);
    }

    public SidebarBrowseProjectPage enableSidebar() {
        this.okButton.click();
        return (SidebarBrowseProjectPage)((Object)this.pageBinder.bind(SidebarBrowseProjectPage.class, new Object[]{this.projectKey}));
    }

    public BrowseProjectPage dismiss() {
        this.cancelButton.click();
        return (BrowseProjectPage)((Object)this.pageBinder.bind(BrowseProjectPage.class, new Object[]{this.projectKey}));
    }
}

