/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page.legacy;

import com.atlassian.jira.projects.pageobjects.webdriver.page.legacy.AbstractProjectTab;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class ReportsTab
extends AbstractProjectTab {
    public static String LINK_ID = "reports-panel-panel";
    @ElementBy(className="versions-list")
    private PageElement reportsList;
    @Inject
    private PageBinder pageBinder;

    public ReportsTab(String projectKey) {
        super("com.atlassian.jira.jira-projects-plugin:" + LINK_ID, projectKey);
    }

    public Report getReport(String reportName) {
        String xpath = "//a[contains(., \"%s\")]/../..";
        PageElement reportElement = this.reportsList.find(By.xpath((String)String.format(xpath, reportName)));
        return (Report)this.pageBinder.bind(Report.class, new Object[]{reportElement});
    }

    public static class Report {
        private final PageElement reportDiv;

        public Report(PageElement reportDiv) {
            this.reportDiv = reportDiv;
        }

        public TimedCondition isVisible() {
            return this.reportDiv.timed().isVisible();
        }
    }
}

