/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class Subnavigator {
    private String id;
    private PageElement trigger;
    private PageElement options;
    @Inject
    private PageElementFinder pageElementFinder;

    public Subnavigator() {
        this(null);
    }

    public Subnavigator(String id) {
        this.id = id;
    }

    @WaitUntil
    public void ready() {
        String triggerSelector = "#subnav-trigger";
        String optionsSelector = "#subnav-opts";
        if (this.id != null) {
            triggerSelector = triggerSelector + "-" + this.id;
            optionsSelector = optionsSelector + "-" + this.id;
        }
        this.trigger = this.pageElementFinder.find(By.cssSelector((String)triggerSelector));
        this.options = this.pageElementFinder.find(By.cssSelector((String)optionsSelector));
        Poller.waitUntilTrue((TimedQuery)this.trigger.timed().isVisible());
    }

    public void open() {
        if (!this.isOpen()) {
            this.trigger.click();
        }
        Poller.waitUntilTrue((TimedQuery)this.options.timed().isVisible());
    }

    public void close() {
        if (this.isOpen()) {
            this.trigger.click();
        }
        Poller.waitUntilFalse((TimedQuery)this.options.timed().isVisible());
    }

    public boolean isOpen() {
        return this.options != null && this.options.isVisible();
    }

    public void selectItem(String itemId) {
        this.open();
        PageElement item = this.options.find(this.itemByIdSelector(itemId));
        if (item != null) {
            item.click();
        }
    }

    public String getSelectedItemText() {
        return this.trigger.getText();
    }

    public List<String> getAllItems() {
        this.open();
        ArrayList items = Lists.newArrayList((Object[])new String[]{this.getSelectedItemText()});
        for (PageElement anchorElement : this.options.findAll(By.cssSelector((String)"a[data-item-id]"))) {
            items.add(anchorElement.getText());
        }
        this.close();
        return items;
    }

    public boolean hasItemWithId(String itemId) {
        return this.options.find(this.itemByIdSelector(itemId)).isPresent();
    }

    private By itemByIdSelector(String itemId) {
        return By.cssSelector((String)("[data-item-id='" + itemId + "']"));
    }
}

