/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page;

import com.atlassian.jira.pageobjects.components.DropDown;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.SidebarBrowseProjectSubPage;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.ProductInstance;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class ReleasePage
extends SidebarBrowseProjectSubPage {
    public static final String RELEASE_PAGE_KEY = "com.atlassian.jira.jira-projects-plugin:release-page";
    public static String STATUS_NO_FILTER = "no-filter";
    public static String STATUS_UNRELEASED = "unreleased";
    public static String STATUS_RELEASED = "released";
    public static String STATUS_ALL = "all";
    private final String projectKey;
    private final String status;
    private final String contains;
    private final int page;
    @ElementBy(id="versions-table")
    private PageElement versionsTable;
    @ElementBy(id="filter-container")
    private PageElement filterContainer;
    @ElementBy(id="pagination-container")
    private PageElement paginationContainer;
    @ElementBy(cssSelector=".version-filter-status-dropdown-released")
    private PageElement releasedItem;
    @ElementBy(cssSelector=".version-filter-status-dropdown-released input")
    private PageElement releasedCheckbox;
    @ElementBy(cssSelector=".version-filter-status-dropdown-unreleased")
    private PageElement unreleasedItem;
    @ElementBy(cssSelector=".version-filter-status-dropdown-unreleased input")
    private PageElement unreleasedCheckbox;
    private DropDown statusDropdown;
    @Inject
    private PageBinder pageBinder;
    @Inject
    private ProductInstance jiraProduct;
    private boolean obsolete = false;

    public ReleasePage(String projectKey) {
        this(projectKey, null, null, 0);
    }

    public ReleasePage(String projectKey, String status, String contains, int page) {
        super(projectKey);
        this.projectKey = projectKey;
        this.status = status;
        this.contains = contains;
        this.page = page;
    }

    @Init
    public void initContent() {
        this.statusDropdown = (DropDown)this.pageBinder.bind(DropDown.class, new Object[]{By.cssSelector((String)"#version-filter .aui-dropdown2-trigger"), By.cssSelector((String)"#version-filter-status-dropdown")});
    }

    @Override
    public String getUrl() {
        StringBuilder hash = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.status)) {
            hash.append("&status=" + this.status);
        }
        if (StringUtils.isNotBlank((String)this.contains)) {
            hash.append("&contains=" + this.contains);
        }
        if (this.page > 0) {
            hash.append("&page=" + this.page);
        }
        return super.getUrl() + hash.toString();
    }

    public ReleasePage ready() {
        final String url = this.jiraProduct.getBaseUrl() + this.getUrl();
        Poller.waitUntilTrue((String)"Failed to bind because URL is different then the expected one.", (TimedQuery)Conditions.forSupplier((long)this.timeouts.timeoutFor(TimeoutType.PAGE_LOAD), (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return ReleasePage.this.driver.getCurrentUrl().equals(url);
            }
        }));
        return this;
    }

    @Override
    public TimedCondition isAt() {
        return this.versionsTable.timed().isVisible();
    }

    @Override
    public String getPageId() {
        return RELEASE_PAGE_KEY;
    }

    public Version getVersionByName(String name) {
        this.assertNotObsolete();
        String xpath = "//a[text()=\"%s\"]/../..";
        PageElement tableRow = this.versionsTable.find(By.xpath((String)String.format(xpath, name)));
        return (Version)this.pageBinder.bind(Version.class, new Object[]{tableRow});
    }

    public Version getVersionAt(int position) {
        this.assertNotObsolete();
        String selector = "#versions-table tbody tr:nth-child(%d)";
        PageElement tableRow = this.versionsTable.find(By.cssSelector((String)String.format(selector, position)));
        return (Version)this.pageBinder.bind(Version.class, new Object[]{tableRow});
    }

    public TimedCondition isEmpty() {
        return this.versionsTable.find(By.cssSelector((String)".no-results")).timed().isPresent();
    }

    public ReleasePage filterByText(String text) {
        this.assertNotObsolete();
        this.filterContainer.find(By.id((String)"version-filter-text")).type(new CharSequence[]{text});
        return this.bindPage(this.projectKey, this.status, text, this.page);
    }

    public ReleasePage filterByStatus(String status) {
        boolean isValidStatus;
        boolean bl = isValidStatus = status.equals(STATUS_UNRELEASED) || status.equals(STATUS_RELEASED) || status.equals(STATUS_ALL) || status.equals(STATUS_NO_FILTER);
        if (!isValidStatus) {
            throw new IllegalArgumentException("The status to filter by is invalid.");
        }
        this.assertNotObsolete();
        this.statusDropdown.open();
        this.toggleUnreleased(status.equals(STATUS_UNRELEASED) || status.equals(STATUS_ALL));
        this.toggleReleased(status.equals(STATUS_RELEASED) || status.equals(STATUS_ALL));
        this.statusDropdown.close();
        return this.bindPage(this.projectKey, status, this.contains, this.page);
    }

    public ReleasePage goToPage(int number) {
        this.assertNotObsolete();
        String selector = "li:nth-child(%d) a";
        this.paginationContainer.find(By.cssSelector((String)String.format(selector, number + 1))).click();
        return this.bindPage(this.projectKey, this.status, this.contains, number);
    }

    public ReleasePage goToNextPage() {
        this.assertNotObsolete();
        this.paginationContainer.find(By.cssSelector((String)".aui-nav-next a")).click();
        return this.bindPage(this.projectKey, this.status, this.contains, this.page < 2 ? 2 : this.page + 1);
    }

    public ReleasePage goToPreviousPage() {
        this.assertNotObsolete();
        this.paginationContainer.find(By.cssSelector((String)".aui-nav-previous a")).click();
        return this.bindPage(this.projectKey, this.status, this.contains, this.page - 1);
    }

    public TimedQuery<String> getCurrentPageNumber() {
        this.assertNotObsolete();
        return this.paginationContainer.find(By.cssSelector((String)".aui-nav-selected")).timed().getText();
    }

    public TimedQuery<String> getNumberOfPages() {
        this.assertNotObsolete();
        return this.paginationContainer.find(By.cssSelector((String)"ol")).timed().getAttribute("data-total");
    }

    public TimedCondition hasPagination() {
        this.assertNotObsolete();
        return this.paginationContainer.find(By.cssSelector((String)".aui-nav-previous")).timed().isPresent();
    }

    public static Map<String, String> getFilterParamsFromUrl(String url) {
        HashMap params = Maps.newHashMap();
        if (url.contains("?")) {
            String[] hashParams;
            for (String param : hashParams = url.split("[?]")[1].split("&")) {
                String[] paramParts = param.split("=");
                if (paramParts.length != 2) continue;
                params.put(paramParts[0], paramParts[1]);
            }
        }
        return params;
    }

    private ReleasePage bindPage(String projectKey, String status, String contains, int page) {
        this.obsolete = true;
        return ((ReleasePage)((Object)this.pageBinder.bind(ReleasePage.class, new Object[]{projectKey, status, contains, page}))).ready();
    }

    private void assertNotObsolete() {
        if (this.obsolete) {
            throw new IllegalStateException("This page object produced another one. It is obsolete and the new one should be used instead.");
        }
    }

    private void toggleUnreleased(boolean isChecked) {
        if (!this.unreleasedCheckbox.isSelected() && isChecked || this.unreleasedCheckbox.isSelected() && !isChecked) {
            this.unreleasedItem.click();
        }
        Poller.waitUntil((TimedQuery)this.unreleasedCheckbox.timed().isSelected(), (Matcher)Matchers.equalTo((Object)isChecked));
    }

    private void toggleReleased(boolean isChecked) {
        if (!this.releasedCheckbox.isSelected() && isChecked || this.releasedCheckbox.isSelected() && !isChecked) {
            this.releasedItem.click();
        }
        Poller.waitUntil((TimedQuery)this.releasedCheckbox.timed().isSelected(), (Matcher)Matchers.equalTo((Object)isChecked));
    }

    public static class Version {
        @Inject
        private PageBinder pageBinder;
        private final PageElement rowElement;
        private PageElement name;
        private PageElement status;

        public Version(PageElement rowElement) {
            this.rowElement = rowElement;
        }

        @Init
        public void initContent() {
            this.name = this.rowElement.find(By.cssSelector((String)".versions-table__name a"));
            this.status = this.rowElement.find(By.cssSelector((String)".versions-table__status span"));
        }

        public <T> T clickName(Class<T> pageClass, Object ... args) {
            this.name.click();
            return (T)this.pageBinder.bind(pageClass, args);
        }

        public TimedQuery<String> getName() {
            return this.name.timed().getText();
        }

        public TimedQuery<String> getStatus() {
            return this.status.timed().getText();
        }
    }
}

