/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page;

import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.SidebarBrowseProjectSubPage;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.ProductInstance;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;

public class ComponentsPage
extends SidebarBrowseProjectSubPage {
    public static final String COMPONENTS_PAGE_KEY = "com.atlassian.jira.jira-projects-plugin:components-page";
    private final String projectKey;
    private final String contains;
    private final int page;
    @ElementBy(id="components-table")
    private PageElement componentsTable;
    @ElementBy(id="filter-container")
    private PageElement filterContainer;
    @ElementBy(id="pagination-container")
    private PageElement paginationContainer;
    @Inject
    private PageBinder pageBinder;
    @Inject
    private ProductInstance jiraProduct;
    private boolean obsolete = false;

    public ComponentsPage(String projectKey) {
        this(projectKey, null, 0);
    }

    public ComponentsPage(String projectKey, String contains, int page) {
        super(projectKey);
        this.projectKey = projectKey;
        this.contains = contains;
        this.page = page;
    }

    @Override
    public String getUrl() {
        StringBuilder hash = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.contains)) {
            hash.append("&contains=" + this.contains);
        }
        if (this.page > 0) {
            hash.append("&page=" + this.page);
        }
        return super.getUrl() + hash.toString();
    }

    public ComponentsPage ready() {
        final String url = this.jiraProduct.getBaseUrl() + this.getUrl();
        Poller.waitUntilTrue((String)"Failed to bind because URL is different then the expected one.", (TimedQuery)Conditions.forSupplier((long)this.timeouts.timeoutFor(TimeoutType.PAGE_LOAD), (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return ComponentsPage.this.driver.getCurrentUrl().equals(url);
            }
        }));
        return this;
    }

    @Override
    public String getPageId() {
        return COMPONENTS_PAGE_KEY;
    }

    public Component getComponentByName(String name) {
        this.assertNotObsolete();
        String xpath = "//a[text()=\"%s\"]/../..";
        PageElement tableRow = this.componentsTable.find(By.xpath((String)String.format(xpath, name)));
        return (Component)this.pageBinder.bind(Component.class, new Object[]{tableRow});
    }

    public Component getComponentAt(int position) {
        this.assertNotObsolete();
        String selector = "#components-table tbody tr:nth-child(%d)";
        PageElement tableRow = this.componentsTable.find(By.cssSelector((String)String.format(selector, position)));
        return (Component)this.pageBinder.bind(Component.class, new Object[]{tableRow});
    }

    public TimedCondition isEmpty() {
        return this.componentsTable.find(By.cssSelector((String)".no-results")).timed().isPresent();
    }

    public ComponentsPage filterByText(String text) {
        this.assertNotObsolete();
        this.filterContainer.find(By.id((String)"component-filter-text")).clear().type(new CharSequence[]{text});
        return this.bindPage(this.projectKey, text, this.page);
    }

    public ComponentsPage goToPage(int number) {
        this.assertNotObsolete();
        String selector = "li:nth-child(%d) a";
        this.paginationContainer.find(By.cssSelector((String)String.format(selector, number + 1))).click();
        return this.bindPage(this.projectKey, this.contains, number);
    }

    public ComponentsPage goToNextPage() {
        this.assertNotObsolete();
        this.paginationContainer.find(By.cssSelector((String)".aui-nav-next a")).click();
        return this.bindPage(this.projectKey, this.contains, this.page < 2 ? 2 : this.page + 1);
    }

    public ComponentsPage goToPreviousPage() {
        this.assertNotObsolete();
        this.paginationContainer.find(By.cssSelector((String)".aui-nav-previous a")).click();
        return this.bindPage(this.projectKey, this.contains, this.page - 1);
    }

    public TimedQuery<String> getCurrentPageNumber() {
        this.assertNotObsolete();
        return this.paginationContainer.find(By.cssSelector((String)".aui-nav-selected")).timed().getText();
    }

    public TimedQuery<String> getNumberOfPages() {
        this.assertNotObsolete();
        return this.paginationContainer.find(By.cssSelector((String)"ol")).timed().getAttribute("data-total");
    }

    public TimedCondition hasPagination() {
        this.assertNotObsolete();
        return this.paginationContainer.find(By.cssSelector((String)".aui-nav-previous")).timed().isPresent();
    }

    public static Map<String, String> getFilterParamsFromUrl(String url) {
        HashMap params = Maps.newHashMap();
        if (url.contains("?")) {
            String[] hashParams;
            for (String param : hashParams = url.split("[?]")[1].split("&")) {
                String[] paramParts = param.split("=");
                if (paramParts.length != 2) continue;
                params.put(paramParts[0], paramParts[1]);
            }
        }
        return params;
    }

    private ComponentsPage bindPage(String projectKey, String contains, int page) {
        this.obsolete = true;
        return ((ComponentsPage)((Object)this.pageBinder.bind(ComponentsPage.class, new Object[]{projectKey, contains, page}))).ready();
    }

    private void assertNotObsolete() {
        if (this.obsolete) {
            throw new IllegalStateException("This page object produced another one. It is obsolete and the new one should be used instead.");
        }
    }

    public static class Component {
        @Inject
        private PageBinder pageBinder;
        private final PageElement rowElement;
        private PageElement name;
        private PageElement status;

        public Component(PageElement rowElement) {
            this.rowElement = rowElement;
        }

        @Init
        public void initContent() {
            this.name = this.rowElement.find(By.cssSelector((String)".components-table__name a"));
            this.status = this.rowElement.find(By.cssSelector((String)".components-table__status span"));
        }

        public <T> T clickName(Class<T> pageClass, Object ... args) {
            this.name.click();
            return (T)this.pageBinder.bind(pageClass, args);
        }

        public TimedQuery<String> getName() {
            return this.name.timed().getText();
        }

        public TimedQuery<String> getStatus() {
            return this.status.timed().getText();
        }
    }
}

