/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.rules;

import com.atlassian.jira.pageobjects.JiraTestedProduct;
import com.atlassian.jira.projects.pageobjects.backdoor.SidebarDarkFeatureControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

abstract class AbstractProjectCentricNavRule
extends TestWatcher {
    private final JiraTestedProduct jiraTestedProduct;
    private final SidebarDarkFeatureControl sidebarDarkFeatureControl;
    private boolean wasEnabledOnStartup;

    AbstractProjectCentricNavRule(JiraTestedProduct jiraTestedProduct) {
        this.jiraTestedProduct = jiraTestedProduct;
        this.sidebarDarkFeatureControl = new SidebarDarkFeatureControl((JIRAEnvironmentData)jiraTestedProduct.environmentData());
    }

    public final void prepare() {
        this.starting(null);
    }

    public final void cleanUp() {
        this.finished(null);
    }

    protected final void starting(Description description) {
        this.checkIfProjectCentricNavWasEnabledOnStartUp();
        this.doStarting();
    }

    protected void doStarting() {
    }

    protected final void finished(Description description) {
        this.doFinished();
    }

    protected void doFinished() {
    }

    protected boolean projectCentricNavWasEnabledOnStartUp() {
        return this.wasEnabledOnStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableProjectCentric() {
        this.jiraTestedProduct.quickLoginAsSysadmin();
        try {
            this.sidebarDarkFeatureControl.enableSidebarForSite();
        }
        finally {
            this.jiraTestedProduct.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableProjectCentric() {
        this.jiraTestedProduct.quickLoginAsSysadmin();
        try {
            this.sidebarDarkFeatureControl.disableSidebarForSite();
        }
        finally {
            this.jiraTestedProduct.logout();
        }
    }

    private void checkIfProjectCentricNavWasEnabledOnStartUp() {
        try {
            this.wasEnabledOnStartup = this.sidebarDarkFeatureControl.isEnabledForSite();
        }
        catch (UniformInterfaceException ex) {
            ClientResponse clientResponse = ex.getResponse();
            if (clientResponse.getStatus() == 404) {
                this.wasEnabledOnStartup = false;
            }
            throw ex;
        }
    }
}

