/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.func;

import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.projects.pageobjects.func.page.IssuesPage;
import com.atlassian.jira.projects.pageobjects.func.page.NewSummaryPage;
import com.atlassian.jira.projects.pageobjects.func.page.PluginProvidedPage;
import com.atlassian.jira.projects.pageobjects.func.page.ReferencePluginSidebarPage;
import com.atlassian.jira.projects.pageobjects.func.page.ReportPage;
import com.atlassian.jira.projects.pageobjects.func.page.SummaryPage;

public class World {
    private final FuncTestHelperFactory funcTestHelperFactory;
    private String projectKey;

    public World(WorldBuilder worldBuilder) {
        this.funcTestHelperFactory = worldBuilder.funcTestHelperFactory;
        this.projectKey = worldBuilder.key;
    }

    public NewSummaryPage goToNewProjectSummary() {
        NewSummaryPage page = new NewSummaryPage(this.projectKey, "com.atlassian.jira.jira-projects-plugin:summary-page");
        page.setContext(this.funcTestHelperFactory);
        this.funcTestHelperFactory.getNavigation().gotoPage(page.baseUrl());
        return page;
    }

    public SummaryPage gotoSummaryPage() {
        SummaryPage page = new SummaryPage(this.projectKey, "com.atlassian.jira.jira-projects-plugin:summary-panel");
        page.setContext(this.funcTestHelperFactory);
        this.funcTestHelperFactory.getNavigation().gotoPage(page.baseUrl());
        return page;
    }

    public PluginProvidedPage goToRootPage() {
        PluginProvidedPage page = new PluginProvidedPage(this.projectKey, "");
        page.setContext(this.funcTestHelperFactory);
        this.funcTestHelperFactory.getNavigation().gotoPage(page.baseUrl());
        return page;
    }

    public IssuesPage goToIssuesPage() {
        IssuesPage page = new IssuesPage(this.projectKey, "com.atlassian.jira.jira-projects-plugin:issues-panel");
        page.setContext(this.funcTestHelperFactory);
        this.funcTestHelperFactory.getNavigation().gotoPage(page.baseUrl());
        return page;
    }

    public ReportPage goToReportPage() {
        ReportPage page = new ReportPage(this.projectKey, "com.atlassian.jira.jira-projects-plugin:report-page");
        page.setContext(this.funcTestHelperFactory);
        this.funcTestHelperFactory.getNavigation().gotoPage(page.baseUrl());
        return page;
    }

    public PluginProvidedPage gotoPluginProvidedPage() {
        return this.getPluginProvidedPage("com.atlassian.jira.jira-projects-reference-plugin:plugin-provided-link-to-soy-panel");
    }

    public PluginProvidedPage gotoPluginProvidedVelocityPage() {
        return this.getPluginProvidedPage("com.atlassian.jira.jira-projects-reference-plugin:plugin-provided-link-to-velocity-panel");
    }

    public ReferencePluginSidebarPage gotoReferencePluginSidebarPage() {
        ReferencePluginSidebarPage page = new ReferencePluginSidebarPage(this.projectKey);
        page.setContext(this.funcTestHelperFactory);
        this.funcTestHelperFactory.getNavigation().gotoPage(page.baseUrl());
        return page;
    }

    private PluginProvidedPage getPluginProvidedPage(String tabName) {
        PluginProvidedPage page = new PluginProvidedPage(this.projectKey, tabName);
        page.setContext(this.funcTestHelperFactory);
        this.funcTestHelperFactory.getNavigation().gotoPage(page.baseUrl());
        return page;
    }

    public static WorldBuilder builder(FuncTestHelperFactory funcTestHelperFactory) {
        return new WorldBuilder(funcTestHelperFactory);
    }

    public static class WorldBuilder {
        private static final String DISABLE_SIDEBAR_DARK_FEATURE_FLAG = "com.atlassian.jira.projects.ProjectCentricNavigation.Disabled";
        private final FuncTestHelperFactory funcTestHelperFactory;
        private String key;
        private String name;
        private boolean projectCentricNavEnabled = true;
        private boolean throwExceptionsOnErrorStatus;

        public WorldBuilder(FuncTestHelperFactory funcTestHelperFactory) {
            this.funcTestHelperFactory = funcTestHelperFactory;
            this.name = "A Project Name";
            this.key = "KEY";
            this.throwExceptionsOnErrorStatus = true;
        }

        public WorldBuilder withProjectCentricNavigation(boolean projectCentricNavEnabled) {
            this.projectCentricNavEnabled = projectCentricNavEnabled;
            return this;
        }

        public WorldBuilder withProject(String name, String key) {
            this.name = name;
            this.key = key;
            return this;
        }

        public WorldBuilder withExceptionsThrownOnErrorStatus(boolean throwExceptionsOnErrorStatus) {
            this.throwExceptionsOnErrorStatus = throwExceptionsOnErrorStatus;
            return this;
        }

        public World build() {
            this.funcTestHelperFactory.getBackdoor().restoreBlankInstance();
            this.funcTestHelperFactory.getBackdoor().project().addProject(this.name, this.key, "admin");
            this.funcTestHelperFactory.getTester().getDialog().getWebClient().setExceptionsThrownOnErrorStatus(this.throwExceptionsOnErrorStatus);
            this.setProjectCentricDarkFeature(this.projectCentricNavEnabled);
            return new World(this);
        }

        private void setProjectCentricDarkFeature(boolean projectCentricNavEnabled) {
            if (projectCentricNavEnabled) {
                this.funcTestHelperFactory.getBackdoor().darkFeatures().disableForSite(DISABLE_SIDEBAR_DARK_FEATURE_FLAG);
            } else {
                this.funcTestHelperFactory.getBackdoor().darkFeatures().enableForSite(DISABLE_SIDEBAR_DARK_FEATURE_FLAG);
            }
        }
    }
}

