/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.api.sidebar.navigation;

import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class NavigationSection {
    private final String id;
    private final String label;
    private final List<NavigationItem> items;

    private NavigationSection(String id, String label, List<NavigationItem> items) {
        Preconditions.checkNotNull((Object)id, (Object)"The Navigation Section must have an ID");
        this.id = id;
        this.label = label;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        NavigationSection navigationItem = (NavigationSection)object;
        return new EqualsBuilder().append((Object)this.id, (Object)navigationItem.id).append((Object)this.label, (Object)navigationItem.label).append(this.items, navigationItem.items).isEquals();
    }

    public List<NavigationItem> getItems() {
        return Lists.newArrayList(this.items);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.label).append(this.items).toHashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private String id;
        private String label;
        private final List<NavigationItem> items = Lists.newArrayList();

        private Builder() {
        }

        public Builder addItem(NavigationItem item) {
            this.items.add(item);
            return this;
        }

        public Builder addItems(List<NavigationItem> items) {
            this.items.addAll(items);
            return this;
        }

        public NavigationSection build() {
            return new NavigationSection(this.id, this.label, this.items);
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }
    }
}

