/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.api.sidebar.header;

import com.atlassian.jira.projects.api.sidebar.header.HeaderRendererParameters;
import com.atlassian.jira.projects.api.sidebar.header.ScopeFilter;
import com.atlassian.jira.projects.api.sidebar.header.ScopeFilterBuilder;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HeaderRendererParametersBuilder {
    private String heading = null;
    private ScopeFilter scopeFilter = new ScopeFilterBuilder().build();
    private String avatarUrl = null;
    private String linkUrl = null;
    private String projectTypeKey;
    private String projectTypeIcon;
    private boolean selected = false;
    private boolean displayProjectTypeWarning = false;
    private boolean isLazyLoading = false;

    @Nonnull
    public HeaderRendererParametersBuilder heading(@Nonnull String heading) {
        this.heading = heading;
        return this;
    }

    @Nonnull
    public HeaderRendererParametersBuilder scopeFilter(@Nullable ScopeFilter scopeFilter) {
        this.scopeFilter = scopeFilter;
        return this;
    }

    @Nonnull
    public HeaderRendererParametersBuilder avatarUrl(@Nullable String avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    @Nonnull
    public HeaderRendererParametersBuilder linkUrl(@Nullable String linkUrl) {
        this.linkUrl = linkUrl;
        return this;
    }

    @Nonnull
    public HeaderRendererParametersBuilder projectTypeKey(String projectTypeKey) {
        this.projectTypeKey = projectTypeKey;
        return this;
    }

    @Nonnull
    public HeaderRendererParametersBuilder projectTypeIcon(String projectTypeIcon) {
        this.projectTypeIcon = projectTypeIcon;
        return this;
    }

    @Nonnull
    public HeaderRendererParametersBuilder selected(boolean selected) {
        this.selected = selected;
        return this;
    }

    @Nonnull
    public HeaderRendererParametersBuilder displayProjectTypeWarning(boolean displayProjectTypeWarning) {
        this.displayProjectTypeWarning = displayProjectTypeWarning;
        return this;
    }

    @Nonnull
    public HeaderRendererParametersBuilder setLazyLoading(boolean isLazyLoading) {
        this.isLazyLoading = isLazyLoading;
        return this;
    }

    @Nonnull
    public HeaderRendererParameters build() {
        Preconditions.checkState((this.heading != null ? 1 : 0) != 0, (Object)"The heading can not be null");
        if (this.scopeFilter == null) {
            this.scopeFilter = new ScopeFilterBuilder().build();
        }
        return new HeaderRendererParameters(this.heading, this.scopeFilter, this.avatarUrl, this.linkUrl, this.projectTypeKey, this.projectTypeIcon, this.selected, this.displayProjectTypeWarning, this.isLazyLoading);
    }
}

