/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.plugins.mail.extensions.MessageHandlerModuleDescriptor;
import com.atlassian.jira.plugins.mail.extensions.ParamsFormatter;
import com.atlassian.jira.plugins.mail.extensions.PluggableMailHandlerUtils;
import com.atlassian.jira.plugins.mail.internal.DefaultMailLoopDetectionService;
import com.atlassian.jira.plugins.mail.internal.DefaultParamsFormatter;
import com.atlassian.jira.plugins.mail.webwork.MailServerActionSupport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.services.file.AbstractMessageHandlingService;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServer;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.tools.generic.EscapeTool;

@WebSudoRequired
public class ViewMailServers
extends MailServerActionSupport {
    public static final String OUTGOING_MAIL_TAB = "outgoing_mail";
    public static final String INCOMING_MAIL_TAB = "incoming_mail";
    public static final String OUTGOING_MAIL_ACTION = "OutgoingMailServers.jspa";
    public static final String INCOMING_MAIL_ACTION = "IncomingMailServers.jspa";
    private final ServiceManager serviceManager;
    private final ComponentClassManager componentClassManager;
    private final ProjectManager projectManager;
    private final PluginAccessor pluginAccessor;
    private final JiraAuthenticationContext authenticationContext;
    private final UserKeyService userKeyService;
    private final UserFormats userFormatter;
    private final DateTimeFormatter dateTimeFormatter;
    private final ConstantsManager constantsManager;
    private final MailSettings mailSettings;
    private final DefaultMailLoopDetectionService defaultMailLoopDetectionService;
    private String messagesThreshold;
    private String whitelistedDomains;

    public ViewMailServers(ServiceManager serviceManager, ConstantsManager constantsManager, ProjectManager projectManager, PluginAccessor pluginAccessor, MailSettings mailSettings, JiraAuthenticationContext authenticationContext, UserKeyService userKeyService, UserFormats userFormatter, DateTimeFormatter dateTimeFormatter, DefaultMailLoopDetectionService defaultMailLoopDetectionService) {
        this.serviceManager = serviceManager;
        this.constantsManager = constantsManager;
        this.projectManager = projectManager;
        this.pluginAccessor = pluginAccessor;
        this.authenticationContext = authenticationContext;
        this.userKeyService = userKeyService;
        this.userFormatter = userFormatter;
        this.dateTimeFormatter = dateTimeFormatter;
        this.defaultMailLoopDetectionService = defaultMailLoopDetectionService;
        this.componentClassManager = this.getComponentClassManager();
        this.mailSettings = mailSettings;
    }

    @Nonnull
    protected ComponentClassManager getComponentClassManager() {
        return ComponentAccessor.getComponentClassManager();
    }

    @Nullable
    private String getHandlerKey(@Nonnull String messageHandler) {
        MessageHandlerModuleDescriptor descriptor = PluggableMailHandlerUtils.getHandlerKeyByMessageHandler(this.pluginAccessor, messageHandler);
        return descriptor != null ? descriptor.getCompleteKey() : null;
    }

    public String getInvalidPopSettingsMessage() {
        HelpUtil helpUtil = new HelpUtil();
        HelpUtil.HelpPath helpPath = helpUtil.getHelpPath("decodeparameters");
        return this.getText("admin.mailservers.mail.bad.props", "<a href=\"" + helpPath.getUrl() + "\">", "</a>");
    }

    public Collection<JiraServiceContainer> getMailHandlers() {
        Iterable services = this.serviceManager.getServicesManageableBy(this.getLoggedInUser());
        final class IsMailHandlerFilter
        implements Predicate<JiraServiceContainer> {
            IsMailHandlerFilter() {
            }

            public boolean apply(JiraServiceContainer jiraServiceContainer) {
                try {
                    return AbstractMessageHandlingService.class.isAssignableFrom(ViewMailServers.this.componentClassManager.loadClass(jiraServiceContainer.getServiceClass()));
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
        }
        ImmutableList jiraServiceContainers = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)services, (Predicate)new IsMailHandlerFilter()));
        return jiraServiceContainers;
    }

    @Nullable
    public Project getRelatedProject(JiraServiceContainer service) {
        String id = this.getRelatedProjectKey(service);
        return id == null ? null : this.projectManager.getProjectObjByKey(id);
    }

    @Nullable
    public String getRelatedProjectKey(JiraServiceContainer service) {
        Map<String, String> params = this.parseHandlerParams(service);
        String project = params == null ? null : params.get("project");
        return project == null ? null : project.toUpperCase(Locale.getDefault());
    }

    @Nullable
    public String getRelatedIssueId(JiraServiceContainer service) {
        Map<String, String> params = this.parseHandlerParams(service);
        return params != null ? StringUtils.trimToNull((String)params.get("issuetype")) : null;
    }

    @Nullable
    public IssueConstant getRelatedIssueType(JiraServiceContainer service) {
        String issueType = this.getRelatedIssueId(service);
        return issueType == null ? null : this.constantsManager.getIssueTypeObject(issueType);
    }

    public boolean isHandlerUsingObsoleteSettings(JiraServiceContainer service) {
        Map<String, String> params = this.parseHandlerParams(service);
        return params != null && (params.containsKey("port") || params.containsKey("usessl"));
    }

    @Nonnull
    public Collection<Pair<String, String>> getServiceParams(JiraServiceContainer service) {
        ParamsFormatter paramsFormatter = this.getParamsFormatter(service);
        Map<String, String> params = this.parseHandlerParams(service);
        if (params == null) {
            return Collections.singleton(Pair.of((Object)this.getText("common.words.unknown"), (Object)""));
        }
        try {
            String forwardEmail = service.getProperty("forwardEmail");
            if (!StringUtils.isBlank((String)forwardEmail)) {
                params.put("forwardEmail", forwardEmail);
            }
        }
        catch (ObjectConfigurationException e) {
            // empty catch block
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)params.size());
        for (Map.Entry<String, String> from : params.entrySet()) {
            Pair<String, String> formattedValue = paramsFormatter.formatParam(from.getKey(), from.getValue());
            if (formattedValue == null) continue;
            result.add(formattedValue);
        }
        return Ordering.from((Comparator)new Comparator<Pair<String, String>>(){

            @Override
            public int compare(Pair<String, String> o1, Pair<String, String> o2) {
                int i = ((String)o1.first()).compareTo((String)o2.first());
                return i == 0 ? ((String)o1.second()).compareTo((String)o2.second()) : i;
            }
        }).immutableSortedCopy((Iterable)result);
    }

    private ParamsFormatter getParamsFormatter(JiraServiceContainer service) {
        ParamsFormatter paramsFormatter = null;
        try {
            String handlerKey = this.getHandlerKey(service.getProperty("handler"));
            MessageHandlerModuleDescriptor descriptor = (MessageHandlerModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(handlerKey);
            paramsFormatter = descriptor.getParamsFormatter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (paramsFormatter == null) {
            paramsFormatter = new DefaultParamsFormatter(this.authenticationContext, this.userKeyService);
        }
        return paramsFormatter;
    }

    @Nullable
    Map<String, String> parseHandlerParams(JiraServiceContainer service) {
        String params;
        if (!service.isUsable()) {
            return null;
        }
        try {
            params = service.getProperty("handler.params");
            if (params == null) {
                return null;
            }
        }
        catch (ObjectConfigurationException e) {
            return null;
        }
        return ServiceUtils.getParameterMap((String)params);
    }

    @Nullable
    public MailServer getServer(JiraServiceContainer service) {
        if (!service.isUsable()) {
            return null;
        }
        try {
            String popserver = service.getProperty("popserver");
            if (popserver == null) {
                return null;
            }
            Long serverId = Long.parseLong(popserver);
            MailServer mailServer = MailFactory.getServerManager().getMailServer(serverId);
            if (mailServer == null) {
                this.log.warn((Object)String.format("Cannot find mail server with id %s", serverId));
            }
            return mailServer;
        }
        catch (Exception e) {
            this.log.warn((Object)"Cannot parse mail handler configuration", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public String getServerName(JiraServiceContainer service) {
        MailServer server = this.getServer(service);
        return server == null ? null : server.getName();
    }

    @Nonnull
    public String getServerDescription(JiraServiceContainer service) {
        MailServer server = this.getServer(service);
        return server == null ? "" : server.getHostname();
    }

    @Nonnull
    public String getFileServiceDirectory(JiraServiceContainer service) {
        if (!service.isUsable()) {
            return "";
        }
        try {
            return StringUtils.defaultString((String)service.getProperty("subdirectory"), (String)"");
        }
        catch (ObjectConfigurationException e) {
            return "";
        }
    }

    public String getHandlerType(JiraServiceContainer service) {
        String handlerClass;
        if (!service.isUsable()) {
            return "";
        }
        try {
            handlerClass = service.getProperty("handler");
        }
        catch (ObjectConfigurationException e) {
            return "";
        }
        if (StringUtils.isBlank((String)handlerClass)) {
            return "";
        }
        MessageHandlerModuleDescriptor descriptor = PluggableMailHandlerUtils.getHandlerKeyByMessageHandler(this.pluginAccessor, handlerClass);
        return descriptor == null ? handlerClass : descriptor.getName();
    }

    public boolean isOutgoingMailDisabledAtStartup() {
        return this.mailSettings.send().isDisabled() && !this.mailSettings.send().isModifiable();
    }

    public boolean isOutgoingMailDisabledAtRuntime() {
        return this.mailSettings.send().isDisabled() && this.mailSettings.send().isModifiable();
    }

    public boolean isOutgoingMailEnabled() {
        return this.mailSettings.send().isEnabled();
    }

    public String getOutgoingMailDisabledByUser() {
        return this.mailSettings.send().getModifiedBy();
    }

    public String getOutgoingMailDisabledByHtml() {
        String userKey = this.mailSettings.send().getModifiedBy();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userKey)) {
            return "";
        }
        return this.userFormatter.formatter("profileLink").formatUserkey(userKey, "");
    }

    public String getOutgoingMailDisabledMillis() {
        Date modifiedDate = this.mailSettings.send().getModifiedDate();
        return modifiedDate != null ? String.valueOf(modifiedDate.getTime()) : "";
    }

    public String getOutgoingMailDisabledDate() {
        Date date = this.mailSettings.send().getModifiedDate();
        return date == null ? "" : this.dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.COMPLETE).format(date);
    }

    public EscapeTool getEsc() {
        return new EscapeTool();
    }

    public HelpUtil.HelpPath getHelpPath(String key) {
        return new HelpUtil().getHelpPath(key);
    }

    public String getMessagesThreshold() {
        if (this.messagesThreshold == null) {
            this.messagesThreshold = Integer.toString(this.defaultMailLoopDetectionService.getCurrentThreshold());
        }
        return this.messagesThreshold;
    }

    public void setMessagesThreshold(String messagesThreshold) {
        this.messagesThreshold = messagesThreshold;
    }

    public String getWhitelistedDomains() {
        if (this.whitelistedDomains == null) {
            this.whitelistedDomains = Joiner.on((String)", ").join(this.defaultMailLoopDetectionService.getIgnoredSuffixes());
        }
        return this.whitelistedDomains;
    }

    public void setWhitelistedDomains(String whitelistedDomains) {
        this.whitelistedDomains = whitelistedDomains;
    }

    private void saveMessagesThreshold() {
        try {
            int threshold = Integer.parseInt(this.messagesThreshold);
            if (threshold < 0) {
                this.addError("messagesThreshold", this.getText("jmp.mailservers.messages.should.not.be.negative"));
                return;
            }
            this.defaultMailLoopDetectionService.setCurrentThreshold(threshold);
        }
        catch (NumberFormatException e) {
            this.addError("messagesThreshold", this.getText("jmp.mailservers.messages.threshold.invalid.value", this.messagesThreshold));
        }
    }

    private void saveIgnoredDomains() {
        String whitelistedDomainsString = this.getWhitelistedDomains();
        if (whitelistedDomainsString.length() > this.getMaxDomainStringLength()) {
            this.addError("whitelistedDomains", this.getText("jmp.mailservers.whitelisted.domains.text.too.long", this.getMaxDomainStringLength()));
            return;
        }
        ImmutableList domains = ImmutableList.copyOf((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)whitelistedDomainsString));
        this.defaultMailLoopDetectionService.setIgnoredSuffixes((List<String>)domains);
        this.whitelistedDomains = null;
    }

    public String doSaveConfig() {
        this.saveMessagesThreshold();
        this.saveIgnoredDomains();
        return "input";
    }

    public String getTimeLimitInMinutes() {
        return Long.toString(TimeUnit.MINUTES.convert(this.defaultMailLoopDetectionService.getTimeLimitInSeconds(), TimeUnit.SECONDS));
    }

    public int getMaxDomainStringLength() {
        return 1000;
    }
}

