/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;

@WebSudoRequired
public class SendTestMail
extends JiraWebActionSupport {
    private String message;
    private String to;
    private String subject;
    private String messageType;
    private boolean debug;
    private String log;

    public String doDefault() throws Exception {
        String from = null;
        String servername = null;
        String serverdescription = null;
        String username = null;
        String smtpPort = null;
        SMTPMailServer mailserver = MailFactory.getServerManager().getDefaultSMTPMailServer();
        if (mailserver == null) {
            this.log = "You do not currently have a smtp mail server set up yet.";
        } else {
            from = mailserver.getDefaultFrom();
            servername = mailserver.getName();
            serverdescription = mailserver.getDescription();
            username = mailserver.getUsername();
            smtpPort = mailserver.getPort();
        }
        this.setMessage("This is a test message from JIRA. \nServer: " + servername + "\nSMTP Port: " + smtpPort + "\nDescription: " + serverdescription + "\nFrom: " + from + "\nHost User Name: " + username);
        this.setSubject("Test Message From JIRA");
        this.setMessageType("text");
        this.setTo(this.getLoggedInUser().getEmailAddress());
        return "input";
    }

    protected void doValidation() {
        if (!TextUtils.verifyEmail((String)this.to)) {
            this.addError("to", this.getText("admin.errors.must.specify.valid.address"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        block11: {
            block12: {
                mailServer = null;
                oldDebug = false;
                oldDebugStream = null;
                debugLog = new ByteArrayOutputStream();
                mailServer = MailFactory.getServerManager().getDefaultSMTPMailServer();
                if (mailServer != null) break block11;
                this.log = "You do not currently have a smtp mail server set up yet.";
                var5_5 = "input";
                if (mailServer == null) break block12;
                mailServer.setDebug(oldDebug);
                mailServer.setDebugStream(oldDebugStream);
            }
            return var5_5;
        }
        try {
            oldDebug = mailServer.getDebug();
            oldDebugStream = mailServer.getDebugStream();
            mailServer.setDebug(this.debug);
            if (this.debug) {
                mailServer.setDebug(true);
            }
            if (this.debug) {
                mailServer.setDebugStream(new PrintStream(debugLog, true));
            }
            if ("html".equals(this.getMessageType())) {
                mailServer.send(new Email(this.to).setSubject(this.subject).setBody(this.message).setMimeType("text/html"));
            } else {
                mailServer.send(new Email(this.to).setSubject(this.subject).setBody(this.message));
            }
            ** if (mailServer == null) goto lbl-1000
        }
        catch (Exception e) {
            block13: {
                try {
                    this.log = "An error has occurred with sending the test email:\n" + ExceptionUtils.getStackTrace((Throwable)e) + "\n\n" + debugLog;
                    var6_7 = "input";
                    if (mailServer == null) break block13;
                }
                catch (Throwable var7_8) {
                    if (mailServer != null) {
                        mailServer.setDebug(oldDebug);
                        mailServer.setDebugStream(oldDebugStream);
                    }
                    throw var7_8;
                }
                mailServer.setDebug(oldDebug);
                mailServer.setDebugStream(oldDebugStream);
            }
            return var6_7;
        }
lbl-1000:
        // 1 sources

        {
            mailServer.setDebug(oldDebug);
            mailServer.setDebugStream(oldDebugStream);
        }
lbl-1000:
        // 2 sources

        {
        }
        this.log = "Your test message has been sent successfully to " + this.to + ".\n\n" + debugLog;
        return "input";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getLog() {
        return this.log;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Map getMimeTypes() {
        return EasyMap.build((Object)"html", (Object)"HTML", (Object)"text", (Object)"Text");
    }

    public String getActiveTab() {
        return "outgoing_mail";
    }

    public String getCancelURI() {
        return "OutgoingMailServers.jspa";
    }
}

