/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.mail.ServiceConfiguration;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.ServiceTypes;
import com.atlassian.jira.service.services.file.FileService;
import com.atlassian.jira.service.services.mail.MailFetcherService;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.HelpUtil;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.velocity.tools.generic.SortTool;
import webwork.action.ActionContext;

public class MailWebActionSupport
extends JiraWebActionSupport {
    public SortTool getSorter() {
        return new SortTool();
    }

    protected boolean canAddService(String clazz) {
        return this.getServiceTypes().isManageableBy(this.getLoggedInUser(), clazz);
    }

    @Nonnull
    protected ServiceTypes getServiceTypes() {
        return (ServiceTypes)ComponentManager.getComponentInstanceOfType(ServiceTypes.class);
    }

    public boolean canPerformAjaxSearch() {
        return ((UserPickerSearchService)this.getComponentInstanceOfType(UserPickerSearchService.class)).canPerformAjaxSearch(this.getLoggedInUser());
    }

    public BrowserUtils getBrowserUtils() {
        return new BrowserUtils();
    }

    @Nullable
    public static ServiceConfiguration getConfiguration() {
        try {
            return (ServiceConfiguration)ActionContext.getSession().get(ServiceConfiguration.ID);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @Nullable
    public static void setConfiguration(ServiceConfiguration configuration) {
        ActionContext.getSession().put(ServiceConfiguration.ID, configuration);
    }

    @Nonnull
    protected ServiceManager getServiceManager() {
        return ComponentAccessor.getServiceManager();
    }

    @Nullable
    public JiraServiceContainer getService(Long id) {
        JiraServiceContainer service;
        try {
            service = this.getServiceManager().getServiceWithId(id);
        }
        catch (Exception e) {
            this.log.error((Object)String.format("Unabled to get service with id %d", id), (Throwable)e);
            return null;
        }
        for (Class cls : ImmutableSet.of(MailFetcherService.class, FileService.class)) {
            if (!cls.isAssignableFrom(service.getServiceClassObject())) continue;
            return service;
        }
        return null;
    }

    protected boolean canEditService(final Long serviceId) throws Exception {
        return Iterables.any((Iterable)this.getServiceManager().getServicesManageableBy(this.getLoggedInUser()), (Predicate)new Predicate<JiraServiceContainer>(){

            public boolean apply(@Nullable JiraServiceContainer aServiceManageableByTheUser) {
                return serviceId.equals(aServiceManageableByTheUser != null ? aServiceManageableByTheUser.getId() : null);
            }
        });
    }

    public HelpUtil.HelpPath getHelpPath(String key) {
        return new HelpUtil().getHelpPath(key);
    }
}

