/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.PortUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class MailServerActionSupport
extends JiraWebActionSupport {
    protected Long id;
    private String name = null;
    private String description;
    private String type;
    private String serverName;
    private String jndiLocation;
    private String username;
    private boolean changePassword;
    private String password;
    private String from;
    private String prefix;
    private String port;
    private String protocol;
    private Long timeout;
    private boolean tlsRequired;
    private boolean noemail;
    private String mailservertype;
    private Map<String, String> keysForPrefix = MapBuilder.newBuilder().add((Object)"name", (Object)"common.words.name").add((Object)"port", (Object)"admin.mailservers.smtp.port").add((Object)"serverName", (Object)"admin.mailservers.host.name").add((Object)"username", (Object)"common.words.username").add((Object)"password", (Object)"common.words.password").add((Object)"from", (Object)"admin.mailservers.from.address").add((Object)"prefix", (Object)"admin.mailservers.email.prefix").toMap();

    public boolean canManageSmtpMailServers() {
        return this.getPermissionManager().hasPermission(44, this.getLoggedInUser());
    }

    public boolean canManagePopMailServers() {
        return this.getPermissionManager().hasPermission(44, this.getLoggedInUser()) || this.getPermissionManager().hasPermission(0, this.getLoggedInUser());
    }

    public String doView() {
        return "success";
    }

    public String doDefault() throws Exception {
        this.includeResources();
        if (this.id == null || this.id <= 0L) {
            return this.getRedirect("OutgoingMailServers.jspa");
        }
        MailServer mailServer = this.getMailServerManager().getMailServer(this.id);
        if (mailServer == null) {
            return this.getRedirect("OutgoingMailServers.jspa");
        }
        if (this.isPop(mailServer) && this.canManagePopMailServers() || this.isSmtp(mailServer) && this.canManageSmtpMailServers()) {
            this.setDescription(mailServer.getDescription());
            this.setId(mailServer.getId());
            this.setName(mailServer.getName());
            this.setPassword(mailServer.getPassword());
            this.setServerName(mailServer.getHostname());
            this.setProtocol(mailServer.getMailProtocol().getProtocol());
            this.setPort(mailServer.getPort());
            this.setType(mailServer.getType());
            this.setTimeout(mailServer.getTimeout());
            if (MailServerManager.SERVER_TYPES[1].equals(mailServer.getType()) && mailServer instanceof SMTPMailServer) {
                SMTPMailServer smtpMailServer = (SMTPMailServer)mailServer;
                if (StringUtils.isNotBlank((String)smtpMailServer.getJndiLocation())) {
                    this.setJndiLocation(smtpMailServer.getJndiLocation());
                }
                this.setFrom(smtpMailServer.getDefaultFrom());
                this.setPrefix(smtpMailServer.getPrefix());
                this.setTlsRequired(smtpMailServer.isTlsRequired());
            }
            this.setUsername(mailServer.getUsername());
            return "input";
        }
        return "securitybreach";
    }

    private MailServerManager getMailServerManager() {
        return ComponentAccessor.getMailServerManager();
    }

    protected boolean isSmtp(MailServer mailServer) {
        return mailServer.getType().equals(MailServerManager.SERVER_TYPES[1]);
    }

    protected boolean isPop(MailServer mailServer) {
        return mailServer.getType().equals(MailServerManager.SERVER_TYPES[0]);
    }

    private void includeResources() {
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("com.atlassian.jira.jira-mail-plugin:verifymailserverconnection");
    }

    protected void doValidation() {
        this.includeResources();
        if (this.getId() != null) {
            MailServer mailServer = null;
            try {
                mailServer = ComponentAccessor.getMailServerManager().getMailServer(this.id);
            }
            catch (MailException e) {
                throw new RuntimeException(e);
            }
            if (mailServer != null && !StringUtils.defaultString((String)mailServer.getUsername()).equals(StringUtils.defaultString((String)this.getUsername()))) {
                this.changePassword = true;
            }
        }
        if (StringUtils.isBlank((String)this.name)) {
            this.addError("name", this.getText("admin.errors.must.specify.name.of.mail.server"));
        }
        if (StringUtils.isNotBlank((String)this.port) && !PortUtil.isValidPort((String)this.port)) {
            this.addError("port", this.getText("admin.errors.smtp.port.must.be.a.number.between"));
        }
        if (this.getTypes()[0].equals(this.type)) {
            if (StringUtils.isBlank((String)this.serverName)) {
                this.addError("serverName", this.getText("admin.errors.must.specify.location.of.server"));
            }
            if (StringUtils.isBlank((String)this.username)) {
                this.addError("username", this.getText("admin.errors.must.specify.a.username"));
            }
            if (this.changePassword && StringUtils.isBlank((String)this.password)) {
                this.addError("password", this.getText("admin.errors.must.specify.a.password"));
            }
        } else if (this.getTypes()[1].equals(this.type)) {
            if (!TextUtils.verifyEmail((String)this.from)) {
                this.addError("from", this.getText("admin.errors.must.specify.a.valid.from.address"));
            }
            if (StringUtils.isBlank((String)this.prefix)) {
                this.addError("prefix", this.getText("admin.errors.must.specify.a.email.prefix"));
            }
            if (StringUtils.isBlank((String)this.serverName) && StringUtils.isBlank((String)this.jndiLocation)) {
                this.addErrorMessage(this.getText("admin.errors.must.specify.a.host.name.or.jndi.location"));
            } else if (StringUtils.isNotBlank((String)this.jndiLocation) && StringUtils.isNotBlank((String)this.serverName)) {
                this.addErrorMessage(this.getText("admin.errors.cannot.specify.both.a.host.name.and.jndi.location"));
            } else if (StringUtils.isNotBlank((String)this.jndiLocation) && (StringUtils.isNotBlank((String)this.username) || this.changePassword && StringUtils.isNotBlank((String)this.password))) {
                this.addErrorMessage(this.getText("admin.errors.when.specifying.a.jndi.location"));
            } else if (this.changePassword && StringUtils.isNotBlank((String)this.username) && StringUtils.isBlank((String)this.password)) {
                this.addError("password", this.getText("admin.errors.must.specify.password"));
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.must.specify.the.server.type"));
        }
        try {
            MailServer existingMailServer = ComponentAccessor.getMailServerManager().getMailServer(this.getName());
            if (existingMailServer != null && (this.getId() == null || existingMailServer.getId().longValue() != this.getId().longValue())) {
                this.addError("name", this.getText("admin.errors.mail.server.with.this.name.exists"));
            }
        }
        catch (MailException e) {
            this.addErrorMessage(this.getText("admin.errors.an.error.occured.when.processing.the.mail.sever") + " " + e.getMessage());
            this.log.error((Object)"Error processing Mail Server", (Throwable)e);
        }
    }

    public List<PopMailServer> getPopMailServers() throws MailException {
        return this.getMailServerManager().getPopMailServers();
    }

    public List<SMTPMailServer> getSmtpMailServers() throws MailException {
        return this.getMailServerManager().getSmtpMailServers();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = MailServerManager.SERVER_TYPES[0].equals(type) || MailServerManager.SERVER_TYPES[1].equals(type) ? type : null;
    }

    public String[] getTypes() {
        return MailServerManager.SERVER_TYPES;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName != null ? serverName.trim() : null;
    }

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    public void setJndiLocation(String jndiLocation) {
        this.jndiLocation = StringUtils.trim((String)jndiLocation);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Nullable
    public String getPassword() {
        if (this.changePassword) {
            return this.password;
        }
        if (this.id == null) {
            return null;
        }
        try {
            MailServer mailServer = this.getMailServerManager().getMailServer(this.id);
            return mailServer == null ? null : mailServer.getPassword();
        }
        catch (MailException e) {
            this.log.warn((Object)("Cannot retrieve mail server with ID " + this.id), (Throwable)e);
            return null;
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Nullable
    public String getPasswordSet() {
        return this.changePassword ? this.password : null;
    }

    public boolean isChangePassword() {
        return this.changePassword || this.getErrors().containsKey("password");
    }

    public void setChangePassword(boolean changePassword) {
        this.changePassword = changePassword;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port != null ? port.trim() : null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean isTlsRequired() {
        return this.tlsRequired;
    }

    public void setTlsRequired(boolean tlsRequired) {
        this.tlsRequired = tlsRequired;
    }

    public boolean isValidMailParameters() {
        return JiraSystemProperties.isDecodeMailParameters();
    }

    public MailProtocol[] getSupportedClientProtocols(String type) {
        if (StringUtils.isNotBlank((String)type)) {
            return MailProtocol.getMailProtocolsForServerType((String)type);
        }
        return new MailProtocol[0];
    }

    public String getKeyForPrefix(String prefix) {
        String key = this.keysForPrefix.get(prefix);
        return key != null ? key : prefix;
    }

    public boolean isNoemail() {
        return this.noemail;
    }

    public void setNoemail(boolean noemail) {
        this.noemail = noemail;
    }

    public String getMailservertype() {
        return this.mailservertype;
    }

    public void setMailservertype(String mailservertype) {
        this.mailservertype = mailservertype;
    }

    public String getActiveTab() {
        return "mail_servers";
    }

    protected void configureSocks(MailServer mailServer) {
        FeatureManager featureManager = (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);
        if (featureManager.isEnabled(CoreFeatures.ON_DEMAND)) {
            Properties systemProperties = System.getProperties();
            mailServer.setSocksHost(systemProperties.getProperty("studio.socks.host"));
            mailServer.setSocksPort(systemProperties.getProperty("studio.socks.port"));
        }
    }
}

