/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugins.mail.HandlerDetailsValidator;
import com.atlassian.jira.plugins.mail.handlers.CreateIssueHandler;
import com.atlassian.jira.plugins.mail.handlers.CreateOrCommentHandler;
import com.atlassian.jira.plugins.mail.handlers.RegexCommentHandler;
import com.atlassian.jira.plugins.mail.model.HandlerDetailsModel;
import com.atlassian.jira.plugins.mail.model.IssueTypeModel;
import com.atlassian.jira.plugins.mail.model.OptionModel;
import com.atlassian.jira.plugins.mail.model.ProjectModel;
import com.atlassian.jira.plugins.mail.webwork.AbstractEditHandlerDetailsWebAction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.ObjectMapper;

@WebSudoRequired
public class EditHandlerDetailsWebAction
extends AbstractEditHandlerDetailsWebAction {
    private static final Map<String, String> fieldLabels = ImmutableMap.builder().put((Object)"project", (Object)"common.concepts.project").put((Object)"issuetype", (Object)"common.concepts.issuetype").put((Object)"stripquotes", (Object)"jmp.editHandlerDetails.stripquotes").put((Object)"reporterusername", (Object)"jmp.editHandlerDetails.reporterusername").put((Object)"splitregex", (Object)"jmp.editHandlerDetails.splitregex").put((Object)"catchemail", (Object)"jmp.editHandlerDetails.catchemail").put((Object)"bulk", (Object)"jmp.editHandlerDetails.bulk").put((Object)"forwardEmail", (Object)"admin.service.common.handler.forward.email").put((Object)"createusers", (Object)"jmp.editHandlerDetails.createusers").put((Object)"notifyusers", (Object)"jmp.editHandlerDetails.notifyusers").put((Object)"ccassignee", (Object)"jmp.editHandlerDetails.ccassignee").put((Object)"ccwatcher", (Object)"jmp.editHandlerDetails.ccwatcher").put((Object)"port", (Object)"jmp.editHandlerDetails.port").put((Object)"usessl", (Object)"jmp.editHandlerDetails.usessl").build();
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final HandlerDetailsValidator detailsValidator;
    private HandlerDetailsModel details;
    private final List<Project> projects;
    private String detailsJson;

    public EditHandlerDetailsWebAction(IssueTypeSchemeManager issueTypeSchemeManager, ProjectManager projectManager, HandlerDetailsValidator detailsValidator, PluginAccessor pluginAccessor) {
        super(pluginAccessor);
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.detailsValidator = detailsValidator;
        this.details = new HandlerDetailsModel();
        this.details.setNotifyusers(true);
        this.projects = projectManager.getProjectObjects();
    }

    @Override
    protected void copyServiceSettings(JiraServiceContainer serviceContainer) throws ObjectConfigurationException {
        this.details.setForwardEmail(serviceContainer.getProperty("forwardEmail"));
        this.details.fromServiceParams(serviceContainer.getProperty("handler.params"));
    }

    @Override
    protected Map<String, String> getHandlerParams() {
        return this.details.toServiceParams();
    }

    @Override
    protected Map<String, String[]> getAdditionalServiceParams() throws Exception {
        return MapBuilder.newBuilder((Object)"forwardEmail", (Object)new String[]{this.details.getForwardEmail()}).toMutableMap();
    }

    protected void doValidation() {
        if (this.configuration == null) {
            return;
        }
        super.doValidation();
        if (this.detailsJson == null) {
            this.addErrorMessage("No configuration data sent via detailsJson field.");
            return;
        }
        try {
            this.details = (HandlerDetailsModel)new ObjectMapper().readValue(this.detailsJson, HandlerDetailsModel.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.addErrorCollection(this.detailsValidator.validateDetails(this.details));
    }

    public static Map<String, String> getFieldLabels() {
        return fieldLabels;
    }

    public void setDetailsJson(String json) {
        this.detailsJson = json;
    }

    @Nonnull
    public String getDetailsJson() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this.details);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public String getBulkOptionsJson() {
        ArrayList options = Lists.newArrayList((Object[])new OptionModel[]{new OptionModel(this.getText("jmp.editHandlerDetails.bulk.ignore"), "ignore"), new OptionModel(this.getText("jmp.editHandlerDetails.bulk.forward"), "forward"), new OptionModel(this.getText("jmp.editHandlerDetails.bulk.delete"), "delete"), new OptionModel(this.getText("jmp.editHandlerDetails.bulk.accept"), "accept")});
        try {
            return new ObjectMapper().writeValueAsString((Object)options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public String getProjectsJson() {
        ArrayList suggestions = Lists.newArrayList((Iterable)Iterables.transform(this.projects, (Function)new Function<Project, ProjectModel>(){

            public ProjectModel apply(Project project) {
                return new ProjectModel(project.getName(), project.getKey(), Lists.newArrayList((Iterable)Iterables.transform((Iterable)EditHandlerDetailsWebAction.this.issueTypeSchemeManager.getIssueTypesForProject(project), (Function)new Function<IssueType, IssueTypeModel>(){

                    public IssueTypeModel apply(IssueType from) {
                        return new IssueTypeModel(from.getName(), from.getId());
                    }
                })));
            }
        }));
        try {
            return new ObjectMapper().writeValueAsString((Object)suggestions);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isCreateOrCommentHandlerSelected() {
        return CreateOrCommentHandler.class.isAssignableFrom(this.descriptor.getMessageHandler());
    }

    public boolean isCreateIssueHandlerSelected() {
        return CreateIssueHandler.class.isAssignableFrom(this.descriptor.getMessageHandler());
    }

    public boolean isRegexCommentHandlerSelected() {
        return RegexCommentHandler.class.isAssignableFrom(this.descriptor.getMessageHandler());
    }
}

