/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.plugins.mail.ServiceConfiguration;
import com.atlassian.jira.plugins.mail.extensions.MessageHandlerModuleDescriptor;
import com.atlassian.jira.plugins.mail.webwork.MailWebActionSupport;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public abstract class AbstractEditHandlerDetailsWebAction
extends MailWebActionSupport {
    static final Logger log = Logger.getLogger(AbstractEditHandlerDetailsWebAction.class);
    protected final ServiceConfiguration configuration = AbstractEditHandlerDetailsWebAction.getConfiguration();
    protected final PluginAccessor pluginAccessor;
    protected MessageHandlerModuleDescriptor descriptor;

    public AbstractEditHandlerDetailsWebAction(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        if (this.configuration != null) {
            this.descriptor = (MessageHandlerModuleDescriptor)pluginAccessor.getEnabledPluginModule(this.configuration.getHandlerKey());
        }
    }

    public String doDefault() throws Exception {
        String result = super.doDefault();
        if (this.configuration == null || this.descriptor == null) {
            return this.returnCompleteWithInlineRedirect("EditServerDetails!default.jspa");
        }
        if (this.configuration.getServiceId() != null) {
            JiraServiceContainer serviceContainer = this.getService(this.configuration.getServiceId());
            if (serviceContainer != null) {
                this.copyServiceSettings(serviceContainer);
            } else {
                return this.returnCompleteWithInlineRedirect("IncomingMailServers.jspa");
            }
        }
        return result;
    }

    protected abstract void copyServiceSettings(JiraServiceContainer var1) throws ObjectConfigurationException;

    protected Map<String, String[]> getServiceParams() throws Exception {
        return MapBuilder.newBuilder().addAll(this.configuration.toServiceParams(this.pluginAccessor)).addAll(this.getAdditionalServiceParams()).add((Object)"handler.params", (Object)new String[]{ServiceUtils.toParameterString(this.getHandlerParams())}).toMutableMap();
    }

    protected abstract Map<String, String> getHandlerParams();

    protected Map<String, String[]> getAdditionalServiceParams() throws Exception {
        return Collections.emptyMap();
    }

    @Nonnull
    public String getHandlerName() {
        return this.configuration != null ? this.pluginAccessor.getEnabledPluginModule(this.configuration.getHandlerKey()).getName() : "";
    }

    public boolean isEditing() {
        return this.configuration != null && this.configuration.getServiceId() != null;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.configuration == null) {
            return this.returnCompleteWithInlineRedirect("EditServerDetails!default.jspa");
        }
        if (this.isEditing() && !this.canEditService(this.configuration.getServiceId()) || !this.isEditing() && !this.canAddService(this.configuration.getServiceClass())) {
            return "securitybreach";
        }
        try {
            long delay = this.configuration.getDelay() * 60000L;
            if (!this.isEditing()) {
                this.getServiceManager().addService(this.configuration.getServiceName(), this.configuration.getServiceClass(), delay, this.getServiceParams()).getId();
            } else {
                JiraServiceContainer service = this.getServiceManager().getServiceWithId(this.configuration.getServiceId());
                if (!service.getName().equals(this.configuration.getServiceName()) || !service.getServiceClass().equals(this.configuration.getServiceClass())) {
                    if (!this.canAddService(this.configuration.getServiceClass())) {
                        return "securitybreach";
                    }
                    Long serviceId = this.getServiceManager().addService(this.configuration.getServiceName(), this.configuration.getServiceClass(), delay, this.getServiceParams()).getId();
                    this.getServiceManager().removeService(this.configuration.getServiceId());
                    this.configuration.setServiceId(serviceId);
                    AbstractEditHandlerDetailsWebAction.setConfiguration(this.configuration);
                } else {
                    this.getServiceManager().editService(this.configuration.getServiceId(), delay, this.getServiceParams());
                }
            }
            if (this.getHasErrorMessages()) {
                return "input";
            }
            return this.returnCompleteWithInlineRedirect("IncomingMailServers.jspa");
        }
        catch (Exception e) {
            log.error((Object)this.getText("jmp.editHandlerDetails.cant.add.service", this.configuration.getServiceName()), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.error.adding.service") + " " + e.toString() + ".");
            return "input";
        }
    }

    protected class WebWorkErrorCollector
    implements MessageHandlerErrorCollector {
        public void info(String info) {
            log.info((Object)info);
        }

        public void info(String info, Throwable e) {
            log.info((Object)info, e);
        }

        public void error(String s, Throwable throwable) {
            AbstractEditHandlerDetailsWebAction.this.addErrorMessage(s);
        }

        public void error(String s) {
            AbstractEditHandlerDetailsWebAction.this.addErrorMessage(s);
        }

        public void warning(String s) {
            log.warn((Object)s);
        }

        public void warning(String s, Throwable throwable) {
            log.warn((Object)s, throwable);
        }
    }
}

